/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.block.phlogiport;

import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.irishgreencitrus.occultengineering.content.block.phlogiport.PhlogiportSignalParticleData;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhlogiportSignalParticle
extends TextureSheetParticle {
    private final PositionSource target;
    private final Vec3 startingPosition;
    public static final Vec3 offset = new Vec3(0.0, 0.40625, 0.0);

    protected PhlogiportSignalParticle(ClientLevel level, double x, double y, double z, PositionSource target, int lifetime) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.quadSize = 0.5f;
        this.target = target;
        this.lifetime = lifetime;
        this.startingPosition = new Vec3(x, y, z);
        this.hasPhysics = false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        Optional targetPos = this.target.getPosition((Level)this.level);
        if (targetPos.isEmpty()) {
            this.remove();
            return;
        }
        float percentage = (float)this.age / (float)this.lifetime;
        Vec3 newPos = this.startingPosition.lerp(((Vec3)targetPos.get()).add(offset), (double)percentage);
        this.x = newPos.x();
        this.y = newPos.y();
        this.z = newPos.z();
        this.setPos(newPos.x, newPos.y, newPos.z);
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        this.renderSignal(vertexConsumer, camera, partialTicks, q -> q.rotateZ(this.roll + (float)Math.PI));
        this.renderSignal(vertexConsumer, camera, partialTicks, q -> q.rotateY((float)(-Math.PI)).rotateZ(this.roll));
    }

    private void renderSignal(VertexConsumer buffer, Camera camera, float partialTicks, Consumer<Quaternionf> quatConsumer) {
        Vec3 currentPos = new Vec3(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x), Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y), Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z));
        Quaternionf rotation = new Quaternionf();
        Optional targetPosOpt = this.target.getPosition((Level)this.level);
        if (targetPosOpt.isPresent()) {
            Vector3f travelAxis = ((Vec3)targetPosOpt.get()).add(offset).subtract(currentPos).normalize().toVector3f();
            Vector3f localX = travelAxis.normalize();
            localX.normalize();
            Vector3f localY = new Vector3f(0.0f, 1.0f, 0.0f);
            localY = camera.getUpVector();
            localY.normalize();
            Vector3f localZ = new Vector3f();
            localX.cross((Vector3fc)localY, localZ);
            localZ.normalize();
            localZ.cross((Vector3fc)localX, localY);
            localY.normalize();
            Matrix3f rotMatrix = new Matrix3f((Vector3fc)localX, (Vector3fc)localY, (Vector3fc)localZ);
            rotation.setFromNormalized((Matrix3fc)rotMatrix);
        } else {
            rotation.set((Quaternionfc)camera.rotation());
        }
        Vec3 cameraPos = camera.getPosition();
        double particleX = currentPos.x - cameraPos.x;
        double particleY = currentPos.y - cameraPos.y;
        double particleZ = currentPos.z - cameraPos.z;
        Vector3f[] quad = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        quatConsumer.accept(rotation);
        float quadSize = this.getQuadSize(partialTicks);
        for (Vector3f corner : quad) {
            corner.rotate((Quaternionfc)rotation);
            corner.mul(quadSize);
            corner.add((float)particleX, (float)particleY, (float)particleZ);
        }
        float u0 = this.getU0();
        float v0 = this.getV0();
        float u1 = this.getU1();
        float v1 = this.getV1();
        float[] ucoords = new float[]{u1, u1, u0, u0};
        float[] vcoords = new float[]{v1, v0, v0, v1};
        int lightLevel = this.getLightColor(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f corner = quad[i];
            buffer.addVertex(corner.x, corner.y, corner.z).setUv(ucoords[i], vcoords[i]).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lightLevel, lightLevel);
        }
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<PhlogiportSignalParticleData> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(PhlogiportSignalParticleData type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PhlogiportSignalParticle particle = new PhlogiportSignalParticle(level, x, y, z, type.destination(), type.arrivalInTicks());
            particle.pickSprite(this.sprite);
            particle.setAlpha(1.0f);
            return particle;
        }
    }
}

