/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.fluid;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import io.github.irishgreencitrus.occultengineering.mixin.accessor.TankSegmentAccessor;
import java.util.function.Predicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FilteredFluidTankBehaviour
extends SmartFluidTankBehaviour {
    protected final Predicate<FluidStack> fluidFilter;

    public FilteredFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, Predicate<FluidStack> fluidFilter, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety) {
        super(type, be, tanks, tankCapacity, enforceVariety);
        this.fluidFilter = fluidFilter;
        IFluidHandler[] handlers = new IFluidHandler[tanks];
        for (int i = 0; i < tanks; ++i) {
            SmartFluidTankBehaviour.TankSegment tankSegment;
            this.tanks[i] = tankSegment = new SmartFluidTankBehaviour.TankSegment((SmartFluidTankBehaviour)this, tankCapacity);
            handlers[i] = ((TankSegmentAccessor)tankSegment).getTank();
        }
        this.capability = new InternalFluidHandler(handlers, enforceVariety);
    }

    public static FilteredFluidTankBehaviour single(Predicate<FluidStack> fluidFilter, SmartBlockEntity be, int capacity) {
        return new FilteredFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)TYPE, fluidFilter, be, 1, capacity, false);
    }

    public class InternalFluidHandler
    extends SmartFluidTankBehaviour.InternalFluidHandler {
        public InternalFluidHandler(IFluidHandler[] handlers, boolean enforceVariety) {
            super((SmartFluidTankBehaviour)FilteredFluidTankBehaviour.this, handlers, enforceVariety);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!FilteredFluidTankBehaviour.this.fluidFilter.test(resource)) {
                return 0;
            }
            return super.fill(resource, action);
        }
    }
}

