/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.kinetics.fan.processing;

import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FanEnspiritType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos blockPos) {
        BlockState blockState = level.getBlockState(blockPos);
        return blockState.is(OccultEngineeringTags.ENSPIRIT_CATALYST);
    }

    public int getPriority() {
        return 500;
    }

    public boolean canProcess(ItemStack itemStack, Level level) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(itemStack);
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get(), (RecipeInput)recipeInput, level);
        return recipe.isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack itemStack, Level level) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(itemStack);
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get(), (RecipeInput)recipeInput, level);
        return recipe.map(spiritFireRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)itemStack, (Recipe)spiritFireRecipe.value(), (boolean)false)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) != 0) {
            return;
        }
        level.addParticle((ParticleOptions)ParticleTypes.PORTAL, pos.x, pos.y + 0.25, pos.z, 0.0625, 0.0625, 0.0625);
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess airFlowParticleAccess, RandomSource randomSource) {
        airFlowParticleAccess.setColor(5900720);
        airFlowParticleAccess.setAlpha(1.0f);
        if (randomSource.nextInt(6) == 0) {
            airFlowParticleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.PORTAL, 1.0f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            p.addEffect(new MobEffectInstance((Holder)OccultismEffects.THIRD_EYE, 100, 1));
            p.addEffect(new MobEffectInstance(MobEffects.HUNGER, 300, 1));
        }
    }
}

