/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.kinetics.mechanicalArm;

import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.MechanicalChamberBlock;
import io.github.irishgreencitrus.occultengineering.content.block.mechanical_chamber.MechanicalChamberBlockEntity;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class MechanicalChamberInteractionPoint
extends ArmInteractionPointType {
    public boolean canCreatePoint(Level level, BlockPos blockPos, BlockState blockState) {
        return blockState.getBlock() instanceof MechanicalChamberBlock;
    }

    @Nullable
    public ArmInteractionPoint createPoint(Level level, BlockPos blockPos, BlockState blockState) {
        return new MechanicalChamberArmInteractionPoint(this, level, blockPos, blockState);
    }

    public static class MechanicalChamberArmInteractionPoint
    extends ArmInteractionPoint {
        public MechanicalChamberArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        public ItemStack insert(ArmBlockEntity arm, ItemStack stack, boolean simulate) {
            if (stack.is(OccultEngineeringTags.MECHANICAL_CHAMBER_INSERTABLE)) {
                MechanicalChamberBlockEntity mbe;
                Optional<RecipeHolder<RitualRecipe>> ritual;
                BlockEntity be = this.level.getBlockEntity(this.pos);
                if (be == null) {
                    return stack;
                }
                if (be instanceof MechanicalChamberBlockEntity && (ritual = (mbe = (MechanicalChamberBlockEntity)be).getRitualFor(this.level, stack)).isPresent()) {
                    return super.insert(arm, stack, simulate);
                }
            }
            return stack;
        }

        public ItemStack extract(ArmBlockEntity arm, int slot, int amount, boolean simulate) {
            IItemHandler handler = this.getHandler(arm);
            if (handler == null) {
                return ItemStack.EMPTY;
            }
            if (handler.getStackInSlot(0).is(OccultEngineeringTags.MECHANICAL_CHAMBER_INSERTABLE)) {
                return ItemStack.EMPTY;
            }
            return super.extract(arm, slot, amount, simulate);
        }
    }
}

