/*
 * Decompiled with CFR 0.152.
 */
package net.ace.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.util.List;
import net.ace.config.ClientConfigs;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

public class ConfigManager {
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("TweakLite.json").toFile();

    public static void init() {
        JsonElement root;
        if (!CONFIG_FILE.exists()) {
            ConfigManager.save();
        }
        JsonObject obj = (root = JsonUtils.parseJsonFile((File)CONFIG_FILE)) != null && root.isJsonObject() ? root.getAsJsonObject() : new JsonObject();
        ConfigUtils.readConfigBase((JsonObject)obj, (String)"", ClientConfigs.GENERIC_CONFIGS);
        ConfigUtils.readConfigBase((JsonObject)obj, (String)"", ClientConfigs.SURVIVAL_CONFIGS);
        ConfigUtils.readConfigBase((JsonObject)obj, (String)"", ClientConfigs.CREATIVE_CONFIGS);
    }

    public static void save() {
        JsonObject obj = new JsonObject();
        ConfigUtils.writeConfigBase((JsonObject)obj, (String)"", ClientConfigs.GENERIC_CONFIGS);
        ConfigUtils.writeConfigBase((JsonObject)obj, (String)"", ClientConfigs.SURVIVAL_CONFIGS);
        ConfigUtils.writeConfigBase((JsonObject)obj, (String)"", ClientConfigs.CREATIVE_CONFIGS);
        JsonUtils.writeJsonToFile((JsonObject)obj, (File)CONFIG_FILE);
    }

    public static Gui createGui() {
        return new Gui();
    }

    public static class Gui
    extends GuiConfigsBase {
        private static Tab selectedTab = Tab.GENERIC;

        public Gui() {
            super(10, 50, "tweaklite", null, "tweaklite.config.title", new Object[0]);
        }

        public void initGui() {
            super.initGui();
            this.clearOptions();
            int x = 10;
            int y = 26;
            for (Tab tab : Tab.values()) {
                int width = class_310.method_1551().field_1772.method_1727(tab.getDisplayName()) + 10;
                ButtonGeneric button = new ButtonGeneric(x, y, width, 18, tab.getDisplayName(), new String[0]);
                button.setEnabled(tab != selectedTab);
                this.addButton((ButtonBase)button, (buttonBase, mouseButton) -> {
                    selectedTab = tab;
                    this.initGui();
                });
                x += width + 2;
            }
        }

        public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
            return GuiConfigsBase.ConfigOptionWrapper.createFor(selectedTab.getConfigs());
        }

        public static enum Tab {
            GENERIC("Generic", "tweaklite.tab.generic", ClientConfigs.GENERIC_CONFIGS),
            SURVIVAL("Survival", "tweaklite.tab.survival", ClientConfigs.SURVIVAL_CONFIGS),
            CREATIVE("Creative", "tweaklite.tab.creative", ClientConfigs.CREATIVE_CONFIGS);

            private final String translationKey;
            private final List<IConfigBase> configs;

            private Tab(String name, String translationKey, List<IConfigBase> configs) {
                this.translationKey = translationKey;
                this.configs = configs;
            }

            public String getDisplayName() {
                return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
            }

            public List<IConfigBase> getConfigs() {
                return this.configs;
            }
        }
    }
}

