/*
 * Decompiled with CFR 0.152.
 */
package net.ace.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ServerConfigs {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("TweakLite-Server.json");
    private static JsonObject configData = new JsonObject();
    private static final double DEFAULT_ATTACK_RANGE = 3.0;
    private static final double DEFAULT_BLOCK_RANGE = 5.0;
    private static double cachedAttackRange = 3.0;
    private static double cachedBlockRange = 5.0;

    public static void load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(CONFIG_PATH);
                configData = JsonParser.parseString((String)content).getAsJsonObject();
            } else {
                configData = new JsonObject();
                configData.addProperty("player_attack_range", (Number)3.0);
                configData.addProperty("player_block_range", (Number)5.0);
                ServerConfigs.save();
            }
            cachedAttackRange = configData.has("player_attack_range") ? configData.get("player_attack_range").getAsDouble() : 3.0;
            cachedBlockRange = configData.has("player_block_range") ? configData.get("player_block_range").getAsDouble() : 5.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            configData = new JsonObject();
            configData.addProperty("player_attack_range", (Number)3.0);
            configData.addProperty("player_block_range", (Number)5.0);
        }
    }

    public static void save() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)configData.toString(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getAttackRange() {
        return cachedAttackRange;
    }

    public static double getBlockRange() {
        return cachedBlockRange;
    }

    public static void setAttackRange(double value) {
        configData.addProperty("player_attack_range", (Number)value);
        cachedAttackRange = value;
        ServerConfigs.save();
    }

    public static void setBlockRange(double value) {
        configData.addProperty("player_block_range", (Number)value);
        cachedBlockRange = value;
        ServerConfigs.save();
    }

    static {
        ServerConfigs.load();
    }
}

