/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.quasar.abysstech.Config;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.renderer.AbyssalRfGenRenderer;
import net.quasar.abysstech.block.entity.renderer.AbyssalTomeBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.AmalgamatorBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.CreativeVatBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.DisplacedVoidBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.EffigyBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.EntropicForgeBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.EphemeralPotBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.EssenceCoilBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.EssenceJarBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.MagGlassBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.MixableFourBlockStackBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.MortarBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.ScrubberBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.SingleItemContainerBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.StudyBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.TranslatorBlockEntityRenderer;
import net.quasar.abysstech.block.entity.renderer.XpMachineBlockEntityRenderer;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;
import net.quasar.abysstech.effect.AbyssTechEffects;
import net.quasar.abysstech.entity.AbysstechEntities;
import net.quasar.abysstech.entity.client.ChairRenderer;
import net.quasar.abysstech.entity.client.ChattererRenderer;
import net.quasar.abysstech.entity.client.HomunculiRenderer;
import net.quasar.abysstech.entity.client.HuggingSludgeRenderer;
import net.quasar.abysstech.entity.client.LadybugRenderer;
import net.quasar.abysstech.entity.client.SludgeSporeRenderer;
import net.quasar.abysstech.entity.client.WanderingWispRenderer;
import net.quasar.abysstech.fluid.AbyssTechFluidTypes;
import net.quasar.abysstech.fluid.AbyssTechFluids;
import net.quasar.abysstech.fluid.BaseFluidType;
import net.quasar.abysstech.item.AbyssTechArmorMaterials;
import net.quasar.abysstech.item.AbyssTechCreativeModeTabs;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.particle.ButterflyParticles;
import net.quasar.abysstech.particle.EffigyParticles;
import net.quasar.abysstech.particle.EssenceBeamParticles;
import net.quasar.abysstech.particle.EssenceParticles;
import net.quasar.abysstech.particle.ForceParticles;
import net.quasar.abysstech.particle.RisingParticles;
import net.quasar.abysstech.particle.RisingParticlesBig;
import net.quasar.abysstech.particle.ShrinkingSuspendedParticles;
import net.quasar.abysstech.particle.SoundWaveParticles;
import net.quasar.abysstech.particle.SuspendedParticles;
import net.quasar.abysstech.screen.AbyssTechMenuTypes;
import net.quasar.abysstech.screen.custom.GuideBookScreen;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechAttachmentType;
import net.quasar.abysstech.util.AbyssTechItemProperties;
import org.slf4j.Logger;

@Mod(value="abysstech")
public class AbyssTech {
    public static final String MODID = "abysstech";
    private static final Logger LOGGER = LogUtils.getLogger();

    public AbyssTech(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        AbyssTechCreativeModeTabs.register(modEventBus);
        AbyssTechItems.register(modEventBus);
        AbyssTechBlocks.register(modEventBus);
        AbyssTechBlockEntities.register(modEventBus);
        AbyssTechDataComponentTypes.register(modEventBus);
        AbyssTechAttachmentType.register(modEventBus);
        AbyssTechFluidTypes.register(modEventBus);
        AbyssTechFluids.register(modEventBus);
        AbyssTechSounds.register(modEventBus);
        AbysstechEntities.register(modEventBus);
        AbyssTechArmorMaterials.register(modEventBus);
        AbyssTechParticles.register(modEventBus);
        AbyssTechEffects.register(modEventBus);
        AbyssTechMenuTypes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.COWS_LIP.getId(), AbyssTechBlocks.POTTED_COWS_LIP));
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.CHRYSANTHEMUM.getId(), AbyssTechBlocks.POTTED_CHRYSANTHEMUM));
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.GLOBE_THISTLE.getId(), AbyssTechBlocks.POTTED_GLOBE_THISTLE));
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.MARIGOLD.getId(), AbyssTechBlocks.POTTED_MARIGOLD));
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.HYDRANGEA.getId(), AbyssTechBlocks.POTTED_HYDRANGEA));
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.GHOST_PIPE.getId(), AbyssTechBlocks.POTTED_GHOST_PIPE));
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(AbyssTechBlocks.DAHLIA.getId(), AbyssTechBlocks.POTTED_DAHLIA));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="abysstech", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            AbyssTechItemProperties.addCustomItemProperties();
            EntityRenderers.register(AbysstechEntities.CHAIR_ENTITY.get(), ChairRenderer::new);
            EntityRenderers.register(AbysstechEntities.LADYBUG.get(), LadybugRenderer::new);
            EntityRenderers.register(AbysstechEntities.WANDERINGWISP.get(), WanderingWispRenderer::new);
            EntityRenderers.register(AbysstechEntities.HUGGING_SLUDGE.get(), HuggingSludgeRenderer::new);
            EntityRenderers.register(AbysstechEntities.SLUDGE_SPORE.get(), SludgeSporeRenderer::new);
            EntityRenderers.register(AbysstechEntities.CHATTERER.get(), ChattererRenderer::new);
            EntityRenderers.register(AbysstechEntities.HOMUNCULI.get(), HomunculiRenderer::new);
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.MORTAR_BLOCK_ENTITY.get(), MortarBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.ENTROPIC_FORGE_BLOCK_ENTITY.get(), EntropicForgeBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.SINGLE_ITEM_CONTAINER_BLOCK_ENTITY.get(), SingleItemContainerBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.DISPLACED_VOID_BLOCK_ENTITY.get(), DisplacedVoidBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.MIXABLE_FOUR_BLOCK_STACK_BLOCK_ENTITY.get(), MixableFourBlockStackBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.ABYSS_RF_GEN_BLOCK_ENTITY.get(), AbyssalRfGenRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.ESSENCE_JAR_BLOCK_ENTITY.get(), EssenceJarBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.CREATIVE_VAT_BLOCK_ENTITY.get(), CreativeVatBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.XP_MACHINE_BLOCK_ENTITY.get(), XpMachineBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.ESSENCE_COIL_BLOCK_ENTITY.get(), EssenceCoilBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.ABYSSAL_TOME_BLOCK_ENTITY.get(), AbyssalTomeBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.STUDY_BLOCK_ENTITY.get(), StudyBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.MAG_GLASS_BLOCK_ENTITY.get(), MagGlassBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.EFFIGY_BLOCK_ENTITY.get(), EffigyBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.AMALGAMATOR_BLOCK_ENTITY.get(), AmalgamatorBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.TRANSLATOR_BLOCK_ENTITY.get(), TranslatorBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.EPHEMERAL_POT_BLOCK_ENTITY.get(), EphemeralPotBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(AbyssTechBlockEntities.INSTABILITY_STABILIZER_BLOCK_ENTITY.get(), ScrubberBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerFluidType(((BaseFluidType)AbyssTechFluidTypes.INK_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{AbyssTechFluidTypes.INK_FLUID_TYPE.get()});
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)AbyssTechParticles.BUTTERFLY_PARTICLES.get(), ButterflyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.ESSENCE_PARTICLES.get(), EssenceParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.ESSENCE_BEAM_PARTICLES.get(), EssenceBeamParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.LIVELY_BEAM_PARTICLES.get(), EssenceBeamParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.VIBRANT_BEAM_PARTICLES.get(), EssenceBeamParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SOUND_WAVE_PARTICLES.get(), SoundWaveParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SHIVERING_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.WRATHFUL_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.LOVING_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.HAUNTED_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.TIRED_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.INSPIRED_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.DREAMING_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.DIVIDED_PARTICLES.get(), EffigyParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.UNSTABLE_PARTICLES.get(), RisingParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SLUDGE_PARTICLES.get(), RisingParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.EIDOLON_PARTICLES.get(), RisingParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.FORCE_PARTICLES.get(), ForceParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SPARKLE_LUNAR.get(), SuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SPARKLE_SOL.get(), SuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SPARKLE_NORM.get(), SuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.SPARKLE_OUTER.get(), SuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.RED_FLAME.get(), ShrinkingSuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.GREEN_FLAME.get(), ShrinkingSuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.STRANGE_FLAME.get(), ShrinkingSuspendedParticles.Provider::new);
            event.registerSpriteSet((ParticleType)AbyssTechParticles.LOOMING_MAN.get(), RisingParticlesBig.Provider::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)AbyssTechMenuTypes.GUIDE_BOOK_MENU.get(), GuideBookScreen::new);
        }
    }
}

