/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class AbyssBulb
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    public static final IntegerProperty digestionStage = IntegerProperty.create((String)"digestion_stage", (int)0, (int)2);
    public static final IntegerProperty bulbIngredient = IntegerProperty.create((String)"bulb_ingredient", (int)0, (int)7);

    public AbyssBulb(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)digestionStage, (Comparable)Integer.valueOf(0))).setValue((Property)bulbIngredient, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{digestionStage});
        builder.add(new Property[]{bulbIngredient});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Item[] validIngredient = new Item[]{Items.HONEY_BOTTLE, Items.SPIDER_EYE, Items.BROWN_MUSHROOM, (Item)AbyssTechItems.RADIANT_OOZE.get(), AbyssTechBlocks.WISP_JAR.asItem(), Items.MILK_BUCKET};
            if ((Integer)level.getBlockState(pos).getValue((Property)digestionStage) == 0) {
                for (int i = 0; i < validIngredient.length; ++i) {
                    if (!player.getMainHandItem().is(validIngredient[i])) continue;
                    if (player.getMainHandItem().is(validIngredient[5])) {
                        player.addItem(Items.BUCKET.getDefaultInstance());
                    }
                    player.getMainHandItem().shrink(1);
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)bulbIngredient, (Comparable)Integer.valueOf(i + 1))).setValue((Property)digestionStage, (Comparable)Integer.valueOf(1)));
                    level.playSound(null, pos, AbyssTechSounds.BULB_EAT.get(), SoundSource.BLOCKS);
                    break;
                }
            } else if ((Integer)level.getBlockState(pos).getValue((Property)digestionStage) == 2 && player.getMainHandItem().is(Items.GLASS_BOTTLE)) {
                int bulbIng = (Integer)level.getBlockState(pos).getValue((Property)bulbIngredient);
                player.getMainHandItem().shrink(1);
                ItemStack itemResult = switch (bulbIng) {
                    case 2 -> AbyssTechItems.SOUR_NECTAR.toStack();
                    case 3 -> AbyssTechItems.EARTHY_BROTH.toStack();
                    case 4 -> AbyssTechItems.GLOW_JUICE.toStack();
                    case 5 -> Items.EXPERIENCE_BOTTLE.getDefaultInstance();
                    case 6 -> AbyssTechItems.MILKY_TINCTURE.toStack();
                    default -> AbyssTechItems.SWEET_AMBROSIA.toStack();
                };
                AbyssTechUtility.ItemSimpleSpawn(level, pos, itemResult.getItem());
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)digestionStage, (Comparable)Integer.valueOf(0))).setValue((Property)bulbIngredient, (Comparable)Integer.valueOf(0)));
                level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide() && (Integer)level.getBlockState(pos).getValue((Property)digestionStage) == 1) {
            if (level.getBlockState(pos.below(1)).getBlock() == Blocks.MUD) {
                if (random.nextInt(8) > 6) {
                    level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)digestionStage, (Comparable)Integer.valueOf(2)));
                    level.setBlockAndUpdate(pos.below(1), Blocks.PACKED_MUD.defaultBlockState());
                }
            } else if (random.nextInt(12) > 10) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)digestionStage, (Comparable)Integer.valueOf(2)));
            }
        }
        super.randomTick(state, level, pos, random);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!(level.isClientSide() || level.getBlockState(pos.below(1)).is(BlockTags.DIRT) || level.getBlockState(pos.below(1)).is(Blocks.PACKED_MUD) || level.getBlockState(pos.below(1)).is(Blocks.FARMLAND))) {
            level.destroyBlock(pos, true);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below(1));
        return below.is(BlockTags.DIRT) || below.is(Blocks.PACKED_MUD) || below.is(Blocks.FARMLAND);
    }
}

