/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbyssMirrorBlockEntity;
import net.quasar.abysstech.block.entity.custom.TallEntityBlock;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class AbyssMirror
extends TallEntityBlock {
    public static final MapCodec<AbyssMirror> CODEC = AbyssMirror.simpleCodec(AbyssMirror::new);
    public static final BooleanProperty collidingCooldown = BooleanProperty.create((String)"colliding_cooldown");
    public static final BooleanProperty mirrorReady = BooleanProperty.create((String)"mirror_ready");

    public AbyssMirror(BlockBehaviour.Properties properties) {
        super(properties, false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)collidingCooldown, (Comparable)Boolean.valueOf(false))).setValue((Property)mirrorReady, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AbyssMirrorBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{collidingCooldown});
        builder.add(new Property[]{mirrorReady});
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide() && state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM) {
            BlockEntity mirrorBlockEntity;
            int[] tp;
            int searchRadius = 6;
            if (level.getBlockState(pos.above(2)).getBlock() == AbyssTechBlocks.TUNING_CRYSTAL_EMBRACE.get()) {
                searchRadius = 9;
            }
            if (!((Boolean)level.getBlockState(pos).getValue((Property)collidingCooldown)).booleanValue() && ((tp = new int[]{(mirrorBlockEntity = level.getBlockEntity(pos)).getPersistentData().getInt("tar_x"), mirrorBlockEntity.getPersistentData().getInt("tar_y"), mirrorBlockEntity.getPersistentData().getInt("tar_z")})[0] != 0 || tp[1] != 0 || tp[2] != 0) && level.getBlockState(new BlockPos(tp[0], tp[1], tp[2])).getBlock() == AbyssTechBlocks.ABYSS_MIRROR.get() && AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, 10, 2)) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)collidingCooldown, (Comparable)Boolean.valueOf(true)));
                entity.teleportTo((double)((float)tp[0] + 0.5f), (double)tp[1], (double)((float)tp[2] + 0.5f));
                level.playSound(null, pos, AbyssTechSounds.MIRROR_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.playSound(null, new BlockPos(tp[0], tp[1], tp[2]), AbyssTechSounds.MIRROR_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return AbyssMirror.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.ABYSS_MIRROR_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

