/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;

public class AbyssalEngine
extends Block {
    public static final BooleanProperty hasTube = BooleanProperty.create((String)"has_tube");
    public static final BooleanProperty isActive = BooleanProperty.create((String)"is_active");

    public AbyssalEngine(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)hasTube, (Comparable)Boolean.valueOf(false))).setValue((Property)isActive, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{hasTube});
        builder.add(new Property[]{isActive});
    }

    private boolean checkForActive(Level level, BlockPos pos) {
        return level.getBlockState(pos.above(1)).is(AbyssTechBlocks.ABYSS_RF_GEN) || level.getBlockState(pos.below(1)).is(AbyssTechBlocks.BREAKER) || level.getBlockState(pos.above(2)).is(AbyssTechBlocks.XP_MACHINE);
    }

    private boolean checkForTube(Level level, BlockPos pos) {
        BlockState[] updatedNeighbor = new BlockState[]{level.getBlockState(pos.north()), level.getBlockState(pos.south()), level.getBlockState(pos.east()), level.getBlockState(pos.west())};
        for (int i = 0; i < updatedNeighbor.length; ++i) {
            if (!updatedNeighbor[i].is(AbyssTechBlocks.GEM_TUBE_GREEN) && !updatedNeighbor[i].is(AbyssTechBlocks.GEM_TUBE_YELLOW) && !updatedNeighbor[i].is(AbyssTechBlocks.GEM_TUBE_RED)) continue;
            return true;
        }
        return false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockState newState;
        if (!level.isClientSide() && state != (newState = (BlockState)((BlockState)state.setValue((Property)isActive, (Comparable)Boolean.valueOf(this.checkForActive(level, pos)))).setValue((Property)hasTube, (Comparable)Boolean.valueOf(this.checkForTube(level, pos))))) {
            level.setBlockAndUpdate(pos, newState);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide() && ((Boolean)state.getValue((Property)isActive)).booleanValue() && random.nextInt(30) <= 1) {
            BlockPos[] neighborPos;
            for (BlockPos nPos : neighborPos = new BlockPos[]{pos.offset(1, 0, 0), pos.offset(-1, 0, 0), pos.offset(0, 0, 1), pos.offset(0, 0, -1)}) {
                BlockState checkBlock = level.getBlockState(nPos);
                if (!checkBlock.is(AbyssTechBlocks.GEM_TUBE_GREEN) && !checkBlock.is(AbyssTechBlocks.GEM_TUBE_YELLOW) && !checkBlock.is(AbyssTechBlocks.GEM_TUBE_RED)) continue;
                level.setBlockAndUpdate(nPos, ((Block)AbyssTechBlocks.GEM_TUBE_BROKE.get()).withPropertiesOf(checkBlock));
                level.playSound(null, pos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS);
                break;
            }
        }
        super.randomTick(state, level, pos, random);
    }
}

