/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbyssalTomeBlockEntity;
import org.jetbrains.annotations.Nullable;

public class AbyssalTome
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    private static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty clicked = BooleanProperty.create((String)"clicked");
    public static final BooleanProperty isCrafting = BooleanProperty.create((String)"is_crafting");
    public static final BooleanProperty hasItem = BooleanProperty.create((String)"has_item");
    public static final MapCodec<AbyssalTome> CODEC = AbyssalTome.simpleCodec(AbyssalTome::new);

    public AbyssalTome(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)clicked, (Comparable)Boolean.valueOf(false))).setValue((Property)isCrafting, (Comparable)Boolean.valueOf(false))).setValue((Property)hasItem, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{clicked});
        builder.add(new Property[]{isCrafting});
        builder.add(new Property[]{hasItem});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AbyssalTomeBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AbyssalTomeBlockEntity) {
            AbyssalTomeBlockEntity abyssalTomeBlockEntity = (AbyssalTomeBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)abyssalTomeBlockEntity);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbyssalTomeBlockEntity) {
                AbyssalTomeBlockEntity abyssalTomeBlockEntity = (AbyssalTomeBlockEntity)blockEntity;
                if (!player.isShiftKeyDown()) {
                    if (abyssalTomeBlockEntity.isEmpty() && !stack.isEmpty()) {
                        abyssalTomeBlockEntity.setItem(0, stack);
                        stack.shrink(1);
                        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                    } else if (stack.isEmpty() && !abyssalTomeBlockEntity.isEmpty()) {
                        ItemStack stackInPedestal = abyssalTomeBlockEntity.getItem(0);
                        abyssalTomeBlockEntity.clearContent();
                        player.setItemInHand(InteractionHand.MAIN_HAND, stackInPedestal);
                        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else if (!((Boolean)state.getValue((Property)clicked)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)clicked, (Comparable)Boolean.valueOf(true)));
                }
            }
            level.sendBlockUpdated(pos, state, state, 3);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return AbyssalTome.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.ABYSSAL_TOME_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

