/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class BaseNonSeedCrop
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final IntegerProperty age = IntegerProperty.create((String)"age", (int)0, (int)2);
    public static final BooleanProperty fruiting = BooleanProperty.create((String)"fruiting");
    private final Supplier<Item> fruit;
    private final Supplier<Item> knifeDrop;
    Random random = new Random();

    public BaseNonSeedCrop(BlockBehaviour.Properties properties, Supplier<Item> fruit, @Nullable Supplier<Item> knifeDrop) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)fruiting, (Comparable)Boolean.valueOf(false))).setValue((Property)age, (Comparable)Integer.valueOf(0)));
        this.fruit = fruit;
        this.knifeDrop = knifeDrop;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{fruiting});
        builder.add(new Property[]{age});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (((Boolean)level.getBlockState(pos).getValue((Property)fruiting)).booleanValue()) {
                if (player.getMainHandItem().is((Item)AbyssTechItems.MORT_KNIFE.get()) && this.knifeDrop != null) {
                    AbyssTechUtility.SimpleDamageHeldItem(level, pos, player, AbyssTechItems.MORT_KNIFE.asItem());
                    AbyssTechUtility.ItemSimpleSpawn(level, pos, this.knifeDrop.get());
                    level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS);
                } else {
                    AbyssTechUtility.ItemSimpleSpawn(level, pos, this.fruit.get());
                    level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS);
                }
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)fruiting, (Comparable)Boolean.valueOf(false)));
            } else if (player.getItemInHand(hand).is(Items.BONE_MEAL)) {
                boolean success = false;
                if ((Integer)state.getValue((Property)age) < 2) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)age, (Comparable)Integer.valueOf((Integer)state.getValue((Property)age) + 1)));
                    success = true;
                } else if (!((Boolean)state.getValue((Property)fruiting)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)fruiting, (Comparable)Boolean.valueOf(true)));
                    success = true;
                }
                if (success) {
                    player.getItemInHand(hand).shrink(1);
                    level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS);
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)((float)pos.getX() - 0.5f + this.random.nextFloat(1.5f)), (double)((float)pos.getY() - 0.5f + this.random.nextFloat(1.5f)), (double)((float)pos.getZ() - 0.5f + this.random.nextFloat(1.5f)), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide()) {
            if ((Integer)state.getValue((Property)age) < 2) {
                if (random.nextInt(4) == 1) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)age, (Comparable)Integer.valueOf((Integer)state.getValue((Property)age) + 1)));
                }
            } else if (!((Boolean)state.getValue((Property)fruiting)).booleanValue() && random.nextInt(4) == 1) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)fruiting, (Comparable)Boolean.valueOf(true)));
            }
        }
        super.randomTick(state, level, pos, random);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide() && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below(1));
        return below.is(BlockTags.DIRT);
    }
}

