/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.block.custom.MixableFourBlockStack;
import net.quasar.abysstech.block.entity.custom.MixableFourBlockStackBlockEntity;
import net.quasar.abysstech.util.AbyssTechTags;

public class BigBookLike
extends HorizontalBlock {
    public static final BooleanProperty boolState = BooleanProperty.create((String)"bool_state");
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public final MutableComponent bookText;

    public BigBookLike(BlockBehaviour.Properties properties, MutableComponent bookText) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)boolState, (Comparable)Boolean.valueOf(false)));
        this.bookText = bookText;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{boolState});
        builder.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (!player.getMainHandItem().is(AbyssTechTags.Items.BIG_BOOK_LIKE)) {
                if (((Boolean)state.getValue((Property)boolState)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)boolState, (Comparable)Boolean.valueOf(false)));
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)boolState, (Comparable)Boolean.valueOf(true)));
                }
            } else {
                ItemStack toInsert = state.getBlock().asItem().getDefaultInstance();
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((Block)AbyssTechBlocks.MIXABLE_FOUR_BLOCK_STACK.get()).defaultBlockState().setValue((Property)MixableFourBlockStack.itemsIn, (Comparable)Integer.valueOf(2))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof MixableFourBlockStackBlockEntity) {
                    MixableFourBlockStackBlockEntity mixableBe = (MixableFourBlockStackBlockEntity)blockEntity;
                    mixableBe.setItem(0, toInsert);
                    mixableBe.setItem(1, player.getMainHandItem());
                }
                player.getMainHandItem().shrink(1);
            }
            level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    public String getBookText() {
        return this.bookText.getString();
    }
}

