/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockfaceLightLike
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)14.0, (double)4.0);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)6.0, (double)2.0, (double)12.0, (double)10.0, (double)14.0, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)12.0, (double)2.0, (double)6.0, (double)16.0, (double)14.0, (double)10.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)2.0, (double)6.0, (double)4.0, (double)14.0, (double)10.0);
    public static final VoxelShape SHAPE_DOWN = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    private final Supplier<ParticleOptions> particle;
    private final int particlePos;
    Random r = new Random();

    public BlockfaceLightLike(BlockBehaviour.Properties properties, @Nullable Supplier<ParticleOptions> particle, int particlePos) {
        super(properties);
        this.particle = particle;
        this.particlePos = particlePos;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE;
        };
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.particle != null && this.r.nextInt(4) == 1) {
            ParticleOptions sParticle = this.particle.get();
            Vec3 flamePos = this.flamePos(state);
            level.addParticle(sParticle, (double)pos.getX() + flamePos.x, (double)pos.getY() + flamePos.y, (double)pos.getZ() + flamePos.z, 0.0, 0.0, 0.0);
        }
        super.animateTick(state, level, pos, random);
    }

    protected Vec3 flamePos(BlockState state) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                if (this.particlePos == 0) {
                    yield new Vec3(0.5, 0.8, 0.8);
                }
                yield new Vec3(0.5, 0.6, 0.6);
            }
            case Direction.SOUTH -> {
                if (this.particlePos == 0) {
                    yield new Vec3(0.5, 0.8, 0.2);
                }
                yield new Vec3(0.5, 0.6, 0.4);
            }
            case Direction.EAST -> {
                if (this.particlePos == 0) {
                    yield new Vec3(0.2, 0.8, 0.5);
                }
                yield new Vec3(0.4, 0.6, 0.5);
            }
            case Direction.WEST -> {
                if (this.particlePos == 0) {
                    yield new Vec3(0.8, 0.8, 0.5);
                }
                yield new Vec3(0.6, 0.6, 0.5);
            }
            case Direction.DOWN -> {
                if (this.particlePos == 0) {
                    yield new Vec3(0.5, 0.3, 0.5);
                }
                yield new Vec3(0.5, 0.6, 0.5);
            }
            default -> this.particlePos == 0 ? new Vec3(0.5, 0.7, 0.5) : new Vec3(0.5, 0.5, 0.5);
        };
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide() && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> level.getBlockState(pos.north(1)).isFaceSturdy((BlockGetter)level, pos.north(1), Direction.SOUTH);
            case Direction.NORTH -> level.getBlockState(pos.south(1)).isFaceSturdy((BlockGetter)level, pos.south(1), Direction.NORTH);
            case Direction.WEST -> level.getBlockState(pos.east(1)).isFaceSturdy((BlockGetter)level, pos.east(1), Direction.WEST);
            case Direction.EAST -> level.getBlockState(pos.west(1)).isFaceSturdy((BlockGetter)level, pos.west(1), Direction.EAST);
            case Direction.DOWN -> level.getBlockState(pos.above(1)).isFaceSturdy((BlockGetter)level, pos.above(1), Direction.DOWN);
            default -> level.getBlockState(pos.below(1)).isFaceSturdy((BlockGetter)level, pos.below(1), Direction.UP);
        };
    }
}

