/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.BreakerBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import org.jetbrains.annotations.Nullable;

public class Breaker
extends BaseEntityBlock {
    public static final MapCodec<Breaker> CODEC = Breaker.simpleCodec(Breaker::new);
    public static final BooleanProperty upgraded = BooleanProperty.create((String)"upgraded");
    public static final BooleanProperty firstQuarryCheck = BooleanProperty.create((String)"first_quarry_check");
    public static final BooleanProperty quarryActive = BooleanProperty.create((String)"quarry_active");
    public static final IntegerProperty quarrySize = IntegerProperty.create((String)"quarry_size", (int)1, (int)16);

    public Breaker(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)upgraded, (Comparable)Boolean.valueOf(false))).setValue((Property)firstQuarryCheck, (Comparable)Boolean.valueOf(false))).setValue((Property)quarryActive, (Comparable)Boolean.valueOf(false))).setValue((Property)quarrySize, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{upgraded});
        builder.add(new Property[]{firstQuarryCheck});
        builder.add(new Property[]{quarryActive});
        builder.add(new Property[]{quarrySize});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BreakerBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (player.getMainHandItem().is((Item)AbyssTechItems.TUNED_ABYSSAL_GEAR.get()) && !((Boolean)level.getBlockState(pos).getValue((Property)upgraded)).booleanValue()) {
                player.getMainHandItem().shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)((Block)AbyssTechBlocks.BREAKER.get()).defaultBlockState().setValue((Property)upgraded, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, pos, AbyssTechSounds.WRENCH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (player.getMainHandItem().is(AbyssTechItems.MORT_TUNING_WAND)) {
                if ((Integer)state.getValue((Property)quarrySize) < 16) {
                    int newSize = (Integer)state.getValue((Property)quarrySize) + 1;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)quarrySize, (Comparable)Integer.valueOf(newSize)));
                    player.displayClientMessage((Component)Component.literal((String)("Quarry radius is now " + newSize + " blocks long.")), true);
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)quarrySize, (Comparable)Integer.valueOf(1)));
                    player.displayClientMessage((Component)Component.literal((String)"Quarry radius is now 1 block long."), true);
                }
            } else {
                boolean newState = (Boolean)state.getValue((Property)quarryActive) == false;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)quarryActive, (Comparable)Boolean.valueOf(newState)));
                player.displayClientMessage((Component)Component.literal((String)(newState ? "Quarry is active." : "Quarry is on standby.")), true);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return Breaker.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.BREAKER_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

