/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.util.AbyssTechUtility;

public class CakeLike
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape WEST_S1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)13.0);
    public static final VoxelShape WEST_S2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)11.0);
    public static final VoxelShape WEST_S3 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)9.0);
    public static final VoxelShape WEST_S4 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0);
    public static final VoxelShape WEST_S5 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)5.0);
    public static final VoxelShape WEST_S6 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0);
    public static final VoxelShape EAST_S1 = Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape EAST_S2 = Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape EAST_S3 = Block.box((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape EAST_S4 = Block.box((double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape EAST_S5 = Block.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape EAST_S6 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape SOUTH_S1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0);
    public static final VoxelShape SOUTH_S2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)8.0, (double)15.0);
    public static final VoxelShape SOUTH_S3 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)9.0, (double)8.0, (double)15.0);
    public static final VoxelShape SOUTH_S4 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0);
    public static final VoxelShape SOUTH_S5 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)15.0);
    public static final VoxelShape SOUTH_S6 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)15.0);
    public static final VoxelShape NORTH_S1 = Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape NORTH_S2 = Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape NORTH_S3 = Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape NORTH_S4 = Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape NORTH_S5 = Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape NORTH_S6 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final IntegerProperty slice = IntegerProperty.create((String)"slice", (int)0, (int)6);
    private final int hungerPoints;
    private final float saturationPoints;
    private final int effectType;

    public CakeLike(BlockBehaviour.Properties properties, int hungerPoints, float saturationPoints, int effectType) {
        super(properties);
        this.hungerPoints = hungerPoints;
        this.saturationPoints = saturationPoints;
        this.effectType = effectType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)slice, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{slice});
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Integer)pState.getValue((Property)slice)) {
            case 1: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S1;
                    }
                    case SOUTH: {
                        return SOUTH_S1;
                    }
                    case EAST: {
                        return EAST_S1;
                    }
                    case WEST: {
                        return WEST_S1;
                    }
                }
            }
            case 2: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S2;
                    }
                    case SOUTH: {
                        return SOUTH_S2;
                    }
                    case EAST: {
                        return EAST_S2;
                    }
                    case WEST: {
                        return WEST_S2;
                    }
                }
            }
            case 3: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S3;
                    }
                    case SOUTH: {
                        return SOUTH_S3;
                    }
                    case EAST: {
                        return EAST_S3;
                    }
                    case WEST: {
                        return WEST_S3;
                    }
                }
            }
            case 4: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S4;
                    }
                    case SOUTH: {
                        return SOUTH_S4;
                    }
                    case EAST: {
                        return EAST_S4;
                    }
                    case WEST: {
                        return WEST_S4;
                    }
                }
            }
            case 5: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S5;
                    }
                    case SOUTH: {
                        return SOUTH_S5;
                    }
                    case EAST: {
                        return EAST_S5;
                    }
                    case WEST: {
                        return WEST_S5;
                    }
                }
            }
            case 6: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S6;
                    }
                    case SOUTH: {
                        return SOUTH_S6;
                    }
                    case EAST: {
                        return EAST_S6;
                    }
                    case WEST: {
                        return WEST_S6;
                    }
                }
            }
        }
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            int slicesTaken = (Integer)level.getBlockState(pos).getValue((Property)slice);
            if (slicesTaken < 6) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)slice, (Comparable)Integer.valueOf(slicesTaken + 1)));
            } else {
                level.removeBlock(pos, false);
            }
            player.getFoodData().eat(this.hungerPoints, this.saturationPoints);
            level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS);
            switch (this.effectType) {
                case 1: {
                    AbyssTechUtility.randomPositiveEffect(player);
                    break;
                }
                case 2: {
                    AbyssTechUtility.randomNegativeEffect(player);
                    break;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

