/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.BaseDirectionalBlock;
import net.quasar.abysstech.block.custom.PlantLike;

public class CapedGrowingLike
extends PlantLike {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final Supplier<Block> stem;
    private final int growthHeight;
    private final int randGrowthHeight;
    public static final BooleanProperty CAN_GROW = BooleanProperty.create((String)"can_grow");
    final Random random = new Random();

    public CapedGrowingLike(BlockBehaviour.Properties properties, Supplier<Block> stem, int growthHeight, int randGrowthHeight) {
        super(properties);
        this.stem = stem;
        this.growthHeight = growthHeight;
        this.randGrowthHeight = randGrowthHeight;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CAN_GROW, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CAN_GROW});
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide() && ((Boolean)state.getValue((Property)CAN_GROW)).booleanValue()) {
            if (this.validGrow((Level)level, pos)) {
                if (this.stem.get() instanceof BaseDirectionalBlock) {
                    level.setBlockAndUpdate(pos, (BlockState)this.stem.get().defaultBlockState().setValue((Property)BaseDirectionalBlock.FACING, (Comparable)Direction.UP));
                } else {
                    level.setBlockAndUpdate(pos, this.stem.get().defaultBlockState());
                }
                level.setBlockAndUpdate(pos.above(1), state);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CAN_GROW, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected boolean validGrow(Level level, BlockPos pos) {
        return this.getCurrentHeight(level, pos) < this.growthHeight - this.random.nextInt(Math.max(this.randGrowthHeight, 1)) && level.getBlockState(pos.above(1)).isAir();
    }

    private int getCurrentHeight(Level level, BlockPos pos) {
        for (int i = 1; i < this.growthHeight; ++i) {
            if (level.getBlockState(pos.below(i)).is(this.stem.get())) continue;
            return i;
        }
        return this.growthHeight;
    }

    @Override
    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return super.canSurvive(state, level, pos) || level.getBlockState(pos.below(1)).is(this.stem.get());
    }

    public Block getStem() {
        return this.stem.get();
    }
}

