/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CropStemBase
extends Block
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP});
    private final Block fruit;
    Random random = new Random();

    public CropStemBase(BlockBehaviour.Properties properties, Block fruit) {
        super(properties);
        this.fruit = fruit;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        builder.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide()) {
            if (!this.canSurvive(state, (LevelReader)level, pos)) {
                level.destroyBlock(pos, true);
            }
            this.updateFacing(level, pos, state);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide()) {
            this.growStage((Level)level, pos, state);
        }
    }

    private void updateFacing(Level level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) >= 2) {
            Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            BlockPos[] checkPos = new BlockPos[]{pos.north(1), pos.south(1), pos.east(1), pos.west(1)};
            for (int i = 0; i < checkPos.length; ++i) {
                if (!level.getBlockState(checkPos[i]).is(this.fruit)) continue;
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FACING, (Comparable)directions[i]));
                return;
            }
            if (state.getValue((Property)FACING) != Direction.UP) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FACING, (Comparable)Direction.UP));
            }
        }
    }

    private void growFruit(Level level, BlockPos pos, BlockState state) {
        int randIndex;
        BlockPos[] checkPos;
        if (state.getValue((Property)FACING) == Direction.UP && level.getBlockState((checkPos = new BlockPos[]{pos.north(1), pos.south(1), pos.east(1), pos.west(1)})[randIndex = this.random.nextInt(checkPos.length)]).isAir() && level.getBlockState(checkPos[randIndex].below(1)).is(BlockTags.DIRT)) {
            level.setBlockAndUpdate(checkPos[randIndex], this.fruit.defaultBlockState());
            this.updateFacing(level, pos, state);
        }
    }

    private void growStage(Level level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) < 2) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
        } else {
            this.growFruit(level, pos, state);
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below(1)).is(Blocks.FARMLAND);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        this.growStage((Level)serverLevel, blockPos, blockState);
    }
}

