/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.DripStonePrep;
import net.quasar.abysstech.item.AbyssTechItems;

public class CrystalSeed
extends TransparentBlock {
    public static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    public static final IntegerProperty growthStage = IntegerProperty.create((String)"growth_stage", (int)0, (int)4);
    public static final IntegerProperty crystalType = IntegerProperty.create((String)"crystal_type", (int)0, (int)6);
    public static final IntegerProperty modelStage = IntegerProperty.create((String)"model_stage", (int)0, (int)28);
    public static final BooleanProperty isRem = BooleanProperty.create((String)"is_rem");

    public CrystalSeed(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)growthStage, (Comparable)Integer.valueOf(0))).setValue((Property)crystalType, (Comparable)Integer.valueOf(0))).setValue((Property)modelStage, (Comparable)Integer.valueOf(0))).setValue((Property)isRem, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.getMainHandItem().is(AbyssTechItems.REM_POWDER) && !((Boolean)level.getBlockState(pos).getValue((Property)isRem)).booleanValue()) {
            player.getMainHandItem().shrink(1);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)isRem, (Comparable)Boolean.valueOf(true)));
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide()) {
            for (int i = 0; i < 4; ++i) {
                if (!level.getBlockState(pos.above(i)).is(Blocks.POINTED_DRIPSTONE)) continue;
                if (level.getBlockState(pos.above(i + 1)).is((Block)AbyssTechBlocks.DRIP_STONE_PREP.get()) && level.getBlockState(pos.above(i + 2)).is(Blocks.WATER) && (Integer)state.getValue((Property)growthStage) == 0) {
                    if (!((Boolean)level.getBlockState(pos.above(i + 1)).getValue((Property)DripStonePrep.isPrepared)).booleanValue()) continue;
                    int ct = (Integer)level.getBlockState(pos.above(i + 1)).getValue((Property)DripStonePrep.prepType);
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)growthStage, (Comparable)Integer.valueOf(1))).setValue((Property)crystalType, (Comparable)Integer.valueOf(ct))).setValue((Property)modelStage, (Comparable)Integer.valueOf(ct * 4 + 1)));
                    level.setBlockAndUpdate(pos.above(i + 1), Blocks.DRIPSTONE_BLOCK.defaultBlockState());
                    break;
                }
                if (!level.getBlockState(pos.above(i + 1)).is(Blocks.DRIPSTONE_BLOCK) || !level.getBlockState(pos.above(i + 2)).is(Blocks.WATER)) continue;
                if ((Integer)state.getValue((Property)growthStage) > 0 && (Integer)state.getValue((Property)growthStage) < 4) {
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)growthStage, (Comparable)Integer.valueOf((Integer)state.getValue((Property)growthStage) + 1))).setValue((Property)modelStage, (Comparable)Integer.valueOf((Integer)state.getValue((Property)modelStage) + 1)));
                    break;
                }
                if ((Integer)state.getValue((Property)growthStage) < 4) continue;
                Block CrystalPlace = switch ((Integer)state.getValue((Property)crystalType)) {
                    case 0 -> (Block)AbyssTechBlocks.CRYSTAL_PURPLE.get();
                    case 2 -> (Block)AbyssTechBlocks.CRYSTAL_YELLOW.get();
                    case 3 -> (Block)AbyssTechBlocks.CRYSTAL_SKY.get();
                    case 4 -> (Block)AbyssTechBlocks.CRYSTAL_BLUE.get();
                    case 5 -> (Block)AbyssTechBlocks.CRYSTAL_RED.get();
                    case 6 -> (Block)AbyssTechBlocks.CRYSTAL_PINK.get();
                    default -> (Block)AbyssTechBlocks.CRYSTAL_LIME.get();
                };
                int dreamingProb = (Boolean)state.getValue((Property)isRem) != false ? 50 : 98;
                level.setBlockAndUpdate(pos, random.nextInt(100) > dreamingProb ? ((Block)AbyssTechBlocks.CRYSTAL_DREAMING.get()).defaultBlockState() : CrystalPlace.defaultBlockState());
                break;
            }
        }
        super.randomTick(state, level, pos, random);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.crystal_seed.tooltip.1"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.crystal_seed.tooltip.2"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.crystal_seed.tooltip.3"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{growthStage});
        builder.add(new Property[]{crystalType});
        builder.add(new Property[]{modelStage});
        builder.add(new Property[]{isRem});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }
}

