/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.util.growth.GrowthSet;
import org.jetbrains.annotations.Nullable;

public class CustomGrassBlock
extends Block
implements BonemealableBlock {
    private final GrowthSet growthSet;
    private final Block dirtType;
    private final Block pathType;
    private static final BooleanProperty SNOWY = BooleanProperty.create((String)"snowy");
    Random random = new Random();

    public CustomGrassBlock(BlockBehaviour.Properties properties, Block dirtType, GrowthSet growthSet, @Nullable Block pathType) {
        super(properties);
        this.growthSet = growthSet;
        this.dirtType = dirtType;
        this.pathType = pathType;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNOWY});
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above(1)).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            for (int i = 0; i < 5; ++i) {
                BlockPos tarPos = pos.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
                Block foliage = this.growthSet.getRandomFoliage();
                if (!level.getBlockState(tarPos).isAir() || !level.getBlockState(tarPos.below(1)).is(state.getBlock()) || foliage == null) continue;
                level.setBlockAndUpdate(tarPos, foliage.defaultBlockState());
            }
        }
    }

    private boolean isSnowy(Level level, BlockPos pos) {
        return level.getBlockState(pos.above(1)).is(BlockTags.SNOW);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide() && this.isSnowy(level, pos) != ((Boolean)state.getValue((Property)SNOWY)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(this.isSnowy(level, pos))));
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && this.pathType != null && stack.getItem() instanceof ShovelItem) {
            level.setBlockAndUpdate(pos, this.pathType.defaultBlockState());
            level.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide() && level.isAreaLoaded(pos, 3)) {
            if (level.getBlockState(pos.above(1)).isCollisionShapeFullBlock((BlockGetter)level, pos.above(1))) {
                level.setBlockAndUpdate(pos, this.dirtType.defaultBlockState());
            } else {
                for (int i = 0; i < 2; ++i) {
                    BlockPos targetBlockPos = pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1);
                    if (!level.getBlockState(targetBlockPos).is(this.dirtType) || level.getBlockState(targetBlockPos.above(1)).isCollisionShapeFullBlock((BlockGetter)level, targetBlockPos.above(1))) continue;
                    level.setBlockAndUpdate(targetBlockPos, state);
                }
            }
        }
        super.randomTick(state, level, pos, random);
    }
}

