/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.util.growth.GrowthSet;

public class CustomMossBlock
extends Block
implements BonemealableBlock {
    private final GrowthSet growthSet;
    Random random = new Random();

    public CustomMossBlock(BlockBehaviour.Properties properties, GrowthSet growthSet) {
        super(properties);
        this.growthSet = growthSet;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above(1)).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            int i;
            for (i = 0; i < 10; ++i) {
                BlockPos targetBlockPos = pos.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
                if (!this.growthSet.isReplaceableAtPos((Level)level, targetBlockPos) || level.getBlockState(targetBlockPos).is(state.getBlock())) continue;
                level.setBlockAndUpdate(targetBlockPos, state);
            }
            for (i = 0; i < 5; ++i) {
                BlockPos tarPos = pos.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
                Block foliage = this.growthSet.getRandomFoliage();
                if (!level.getBlockState(tarPos).isAir() || !level.getBlockState(tarPos.below(1)).is(state.getBlock()) || foliage == null) continue;
                level.setBlockAndUpdate(tarPos, foliage.defaultBlockState());
            }
        }
    }
}

