/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DrinkLike
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
    public static final IntegerProperty sip = IntegerProperty.create((String)"sip", (int)0, (int)3);
    private final int hungerPoints;
    private final float saturationPoints;

    public DrinkLike(BlockBehaviour.Properties properties, int hungerPoints, float saturationPoints) {
        super(properties);
        this.hungerPoints = hungerPoints;
        this.saturationPoints = saturationPoints;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)sip, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{sip});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            int sipsTaken = (Integer)level.getBlockState(pos).getValue((Property)sip);
            if (sipsTaken < 3) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)sip, (Comparable)Integer.valueOf(sipsTaken + 1)));
            } else {
                level.removeBlock(pos, false);
            }
            player.getFoodData().eat(this.hungerPoints, this.saturationPoints);
            level.playSound(null, pos, SoundEvents.GENERIC_DRINK, SoundSource.BLOCKS);
        }
        return InteractionResult.SUCCESS;
    }
}

