/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.util.AbyssTechTags;

public class DripStonePrep
extends Block {
    public static final BooleanProperty isPrepared = BooleanProperty.create((String)"is_prepared");
    public static final IntegerProperty prepType = IntegerProperty.create((String)"prep_type", (int)0, (int)6);

    public DripStonePrep(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)isPrepared, (Comparable)Boolean.valueOf(false))).setValue((Property)prepType, (Comparable)Integer.valueOf(1)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && !((Boolean)state.getValue((Property)isPrepared)).booleanValue() && player.getMainHandItem().is(AbyssTechTags.Items.CRYSTAL_STARTER)) {
            Item[] starters = new Item[]{(Item)AbyssTechItems.CRYSTAL_STARTER_PURPLE.get(), (Item)AbyssTechItems.CRYSTAL_STARTER_LIME.get(), (Item)AbyssTechItems.CRYSTAL_STARTER_YELLOW.get(), (Item)AbyssTechItems.CRYSTAL_STARTER_SKY.get(), (Item)AbyssTechItems.CRYSTAL_STARTER_BLUE.get(), (Item)AbyssTechItems.CRYSTAL_STARTER_RED.get(), (Item)AbyssTechItems.CRYSTAL_STARTER_PINK.get()};
            int starterType = 0;
            for (int i = 0; i < starters.length; ++i) {
                if (!player.getMainHandItem().is(starters[i])) continue;
                starterType = i;
                break;
            }
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)prepType, (Comparable)Integer.valueOf(starterType))).setValue((Property)isPrepared, (Comparable)Boolean.valueOf(true)));
            player.getMainHandItem().shrink(1);
            level.playSound(null, pos, SoundEvents.SAND_STEP, SoundSource.BLOCKS);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{isPrepared});
        builder.add(new Property[]{prepType});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }
}

