/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.EffigyBlockEntity;
import org.jetbrains.annotations.Nullable;

public class Effigy
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty Locked = BooleanProperty.create((String)"locked");
    public static final MapCodec<Effigy> CODEC = Effigy.simpleCodec(Effigy::new);

    public Effigy(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)Locked, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{Locked});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EffigyBlockEntity(blockPos, blockState);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof EffigyBlockEntity) {
            EffigyBlockEntity effigyBe = (EffigyBlockEntity)blockEntity;
            if (!player.isShiftKeyDown()) {
                this.setType(level, pos, effigyBe);
                level.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Locked, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)Locked) == false)));
                this.setType(level, pos, effigyBe);
                effigyBe.setRenderTick(effigyBe.getRenderTickMax() - 1);
                level.playSound(null, pos, SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 2.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    private void setType(Level level, BlockPos pos, EffigyBlockEntity effigyBe) {
        Block[] effigyType = new Block[]{(Block)AbyssTechBlocks.EFFIGY_SHIVERING.get(), (Block)AbyssTechBlocks.EFFIGY_WRATHFUL.get(), (Block)AbyssTechBlocks.EFFIGY_LOVING.get(), (Block)AbyssTechBlocks.EFFIGY_HAUNTED.get(), (Block)AbyssTechBlocks.EFFIGY_TIRED.get(), (Block)AbyssTechBlocks.EFFIGY_INSPIRED.get(), (Block)AbyssTechBlocks.EFFIGY_DREAMING.get(), (Block)AbyssTechBlocks.EFFIGY_DIVIDED.get()};
        for (int i = 0; i < effigyType.length; ++i) {
            if (!level.getBlockState(pos).is(effigyType[i])) continue;
            effigyBe.setRenderType(i + 1);
            effigyBe.sendUpdate();
            break;
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return Effigy.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.EFFIGY_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

