/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.util.AbyssTechUtility;

public class EightCubeBlockLike
extends HorizontalBlock {
    public static final IntegerProperty amount = IntegerProperty.create((String)"amount", (int)0, (int)7);
    public static final VoxelShape SHAPE_LOWER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape SHAPE_FULL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_S1A = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape WEST_S2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    public static final VoxelShape WEST_S3 = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    public static final VoxelShape EAST_S1A = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    public static final VoxelShape EAST_S2 = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EAST_S3 = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_S1A = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    public static final VoxelShape SOUTH_S2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    public static final VoxelShape SOUTH_S3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    public static final VoxelShape NORTH_S1A = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    public static final VoxelShape NORTH_S2 = Block.box((double)8.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape NORTH_S3 = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape WEST_S4A = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_S5 = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape WEST_S6 = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape EAST_S4A = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    public static final VoxelShape EAST_S5 = Block.box((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_S6 = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_S4A = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape SOUTH_S5 = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_S6 = Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    public static final VoxelShape NORTH_S4A = Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_S5 = Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_S6 = Block.box((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public EightCubeBlockLike(BlockBehaviour.Properties properties, int defaultAmount) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)amount, (Comparable)Integer.valueOf(defaultAmount)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{amount});
        builder.add(new Property[]{FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (player.getMainHandItem().is(state.getBlock().asItem()) && (Integer)state.getValue((Property)amount) < 7) {
                player.getMainHandItem().shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)amount, (Comparable)Integer.valueOf((Integer)state.getValue((Property)amount) + 1)));
                level.playSound(null, pos, SoundEvents.METAL_PLACE, SoundSource.BLOCKS);
            } else if (player.getMainHandItem().isEmpty() && (Integer)state.getValue((Property)amount) > 0) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)amount, (Comparable)Integer.valueOf((Integer)state.getValue((Property)amount) - 1)));
                AbyssTechUtility.ItemSimpleSpawn(level, pos, state.getBlock().asItem());
                level.playSound(null, pos, SoundEvents.METAL_PLACE, SoundSource.BLOCKS);
            } else if (player.getMainHandItem().isEmpty()) {
                AbyssTechUtility.ItemSimpleSpawn(level, pos, state.getBlock().asItem());
                level.playSound(null, pos, SoundEvents.METAL_PLACE, SoundSource.BLOCKS);
                level.removeBlock(pos, false);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Integer)pState.getValue((Property)amount)) {
            case 0: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)NORTH_S3, (VoxelShape[])new VoxelShape[0]);
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SOUTH_S3, (VoxelShape[])new VoxelShape[0]);
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)EAST_S3, (VoxelShape[])new VoxelShape[0]);
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)WEST_S3, (VoxelShape[])new VoxelShape[0]);
                    }
                }
            }
            case 1: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)NORTH_S3, (VoxelShape)NORTH_S1A);
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SOUTH_S3, (VoxelShape)SOUTH_S1A);
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)EAST_S3, (VoxelShape)EAST_S1A);
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)WEST_S3, (VoxelShape)WEST_S1A);
                    }
                }
            }
            case 2: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)NORTH_S2, (VoxelShape)NORTH_S1A);
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SOUTH_S2, (VoxelShape)SOUTH_S1A);
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)EAST_S2, (VoxelShape)EAST_S1A);
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)WEST_S2, (VoxelShape)WEST_S1A);
                    }
                }
            }
            case 3: {
                return SHAPE_LOWER;
            }
            case 4: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape)NORTH_S6);
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape)SOUTH_S6);
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape)EAST_S6);
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape)WEST_S6);
                    }
                }
            }
            case 5: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{NORTH_S6, NORTH_S4A});
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{SOUTH_S6, SOUTH_S4A});
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{EAST_S6, EAST_S4A});
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{WEST_S6, WEST_S4A});
                    }
                }
            }
            case 6: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{NORTH_S5, NORTH_S4A});
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{SOUTH_S5, SOUTH_S4A});
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{EAST_S5, EAST_S4A});
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)SHAPE_LOWER, (VoxelShape[])new VoxelShape[]{WEST_S5, WEST_S4A});
                    }
                }
            }
        }
        return SHAPE_FULL;
    }
}

