/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.EntropicForgeBlockEntity;
import net.quasar.abysstech.block.entity.custom.TallEntityBlock;
import org.jetbrains.annotations.Nullable;

public class EntropicForge
extends TallEntityBlock {
    public static final MapCodec<EntropicForge> CODEC = EntropicForge.simpleCodec(EntropicForge::new);
    public static final BooleanProperty forgeFired = BooleanProperty.create((String)"forge_fired");
    public static final BooleanProperty hasItem = BooleanProperty.create((String)"has_item");

    public EntropicForge(BlockBehaviour.Properties properties) {
        super(properties, false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)forgeFired, (Comparable)Boolean.valueOf(false))).setValue((Property)hasItem, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{forgeFired});
        builder.add(new Property[]{hasItem});
    }

    @Override
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EntropicForgeBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof EntropicForgeBlockEntity) {
            EntropicForgeBlockEntity entropicForgeBlockEntity = (EntropicForgeBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)entropicForgeBlockEntity);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof EntropicForgeBlockEntity) {
                EntropicForgeBlockEntity entropicForgeBlockEntity = (EntropicForgeBlockEntity)blockEntity;
                if (entropicForgeBlockEntity.isEmpty() && !stack.isEmpty()) {
                    entropicForgeBlockEntity.setItem(0, stack);
                    stack.shrink(1);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                } else if (stack.isEmpty() && !entropicForgeBlockEntity.isEmpty()) {
                    ItemStack stackInMortar = entropicForgeBlockEntity.getItem(0);
                    player.setItemInHand(InteractionHand.MAIN_HAND, stackInMortar);
                    entropicForgeBlockEntity.clearContent();
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            level.sendBlockUpdated(pos, state, state, 3);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return EntropicForge.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.ENTROPIC_FORGE_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

