/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.EtherealPlatform;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class EtherealEmitter
extends Block {
    public static final IntegerProperty modelColor = IntegerProperty.create((String)"model_color", (int)0, (int)9);

    public EtherealEmitter(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)modelColor, (Comparable)Integer.valueOf(2)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{modelColor});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        block14: {
            block15: {
                if (level.isClientSide()) break block14;
                if (player.isShiftKeyDown()) break block15;
                Item heldItem = player.getMainHandItem().getItem();
                Item[] validItems = new Item[]{Items.GREEN_DYE, Items.PURPLE_DYE, Items.CYAN_DYE, Items.RED_DYE, Items.LIME_DYE, Items.MAGENTA_DYE, Items.YELLOW_DYE, Items.ORANGE_DYE, Items.BLUE_DYE, Items.LIGHT_BLUE_DYE};
                for (int i = 0; i < validItems.length; ++i) {
                    if (heldItem != validItems[i]) continue;
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)modelColor, (Comparable)Integer.valueOf(i)));
                    player.getMainHandItem().shrink(1);
                    break block14;
                }
                break block14;
            }
            int searchRadius = AbyssTechUtility.embraceTuneDetect(level, pos, -1, false, 6, 9, 9);
            if (!AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, 2, 1)) break block14;
            Block[] mirrors = new Block[]{(Block)AbyssTechBlocks.REFLECTOR_VIBRANT.get(), (Block)AbyssTechBlocks.REFLECTOR_LIVELY.get()};
            Block[] replaceables = new Block[]{(Block)AbyssTechBlocks.ETHEREAL_PLATFORM.get(), Blocks.AIR, Blocks.CAVE_AIR};
            block9: for (int direIter = 0; direIter < 6; ++direIter) {
                int i = 1;
                int iMax = 5;
                if (level.getBlockState(pos.below(1)).getBlock() == AbyssTechBlocks.TUNING_CRYSTAL_VIGOR.get()) {
                    iMax = 11;
                }
                int aX = 0;
                int aY = 0;
                int aZ = 0;
                switch (direIter) {
                    case 0: {
                        aY = -1;
                        break;
                    }
                    case 1: {
                        aY = 1;
                        break;
                    }
                    case 2: {
                        aX = -1;
                        break;
                    }
                    case 3: {
                        aX = 1;
                        break;
                    }
                    case 4: {
                        aZ = -1;
                        break;
                    }
                    case 5: {
                        aZ = 1;
                    }
                }
                if (level.getBlockState(pos.offset(aX, aY, aZ)).getBlock() != mirrors[0] && level.getBlockState(pos.offset(aX, aY, aZ)).getBlock() != mirrors[1]) continue;
                while (i < iMax) {
                    int iX = i * -aX;
                    int iY = i * -aY;
                    int iZ = i * -aZ;
                    if (level.getBlockState(pos.offset(iX, iY, iZ)).getBlock() == replaceables[1] || level.getBlockState(pos.offset(iX, iY, iZ)).getBlock() == replaceables[2]) {
                        level.setBlockAndUpdate(pos.offset(iX, iY, iZ), (BlockState)((Block)AbyssTechBlocks.ETHEREAL_PLATFORM.get()).defaultBlockState().setValue((Property)EtherealPlatform.modelColor, (Comparable)((Integer)level.getBlockState(pos).getValue((Property)modelColor))));
                        level.playSound(null, pos.offset(iX, iY, iZ), AbyssTechSounds.ETHEREAL.get(), SoundSource.BLOCKS);
                    } else {
                        if (level.getBlockState(pos.offset(iX, iY, iZ)).getBlock() != replaceables[0]) continue block9;
                        level.removeBlock(pos.offset(iX, iY, iZ), false);
                        level.playSound(null, pos.offset(iX, iY, iZ), AbyssTechSounds.ETHEREAL.get(), SoundSource.BLOCKS);
                    }
                    ++i;
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }
}

