/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.FermentationBarrelBlockEntity;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrel
extends BaseEntityBlock {
    public static final MapCodec<FermentationBarrel> CODEC = FermentationBarrel.simpleCodec(FermentationBarrel::new);
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final BooleanProperty hasItem = BooleanProperty.create((String)"has_item");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public FermentationBarrel(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)hasItem, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{hasItem});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FermentationBarrelBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FermentationBarrelBlockEntity) {
            FermentationBarrelBlockEntity fermentationBarrelBlockEntity = (FermentationBarrelBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)fermentationBarrelBlockEntity);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FermentationBarrelBlockEntity) {
                FermentationBarrelBlockEntity fermentationBarrelBlockEntity = (FermentationBarrelBlockEntity)blockEntity;
                if (fermentationBarrelBlockEntity.isEmpty() && !stack.isEmpty()) {
                    fermentationBarrelBlockEntity.setItem(0, stack);
                    stack.shrink(1);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                } else if (stack.isEmpty() && !fermentationBarrelBlockEntity.isEmpty()) {
                    ItemStack stackInPedestal = fermentationBarrelBlockEntity.getItem(0);
                    fermentationBarrelBlockEntity.clearContent();
                    player.setItemInHand(InteractionHand.MAIN_HAND, stackInPedestal);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            level.sendBlockUpdated(pos, state, state, 3);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return FermentationBarrel.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.FERMENTATION_BARREL_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

