/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.util.AbyssTechUtility;

public class FourServingFoodCauldron
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final IntegerProperty SERVING = IntegerProperty.create((String)"serving", (int)0, (int)3);
    private final Supplier<Block> remainingBlock;
    private final Supplier<Item> useItem;
    private final Supplier<Item> normalResult;
    private final Supplier<Item> hotResult;

    public FourServingFoodCauldron(BlockBehaviour.Properties properties, Supplier<Block> remainingBlock, Supplier<Item> useItem, Supplier<Item> normalResult, Supplier<Item> hotResult) {
        super(properties);
        this.remainingBlock = remainingBlock;
        this.useItem = useItem;
        this.normalResult = normalResult;
        this.hotResult = hotResult;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SERVING, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SERVING});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.getItemInHand(hand).is(this.useItem.get())) {
            int servingsTaken = (Integer)level.getBlockState(pos).getValue((Property)SERVING);
            if (servingsTaken < 3) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)SERVING, (Comparable)Integer.valueOf(servingsTaken + 1)));
            } else {
                level.setBlockAndUpdate(pos, this.remainingBlock.get().defaultBlockState());
            }
            player.getItemInHand(hand).shrink(1);
            AbyssTechUtility.ItemSimpleSpawn(level, player.getOnPos().above(1), level.getBlockState(pos.below(1)).is(Blocks.CAMPFIRE) ? this.hotResult.get() : this.normalResult.get());
            level.playSound(null, pos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS, 1.0f, 1.5f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

