/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.custom.TallBlock;
import net.quasar.abysstech.sound.AbyssTechSounds;

public class Gong
extends TallBlock {
    public static final IntegerProperty FACING_EIGHT_SIDES = IntegerProperty.create((String)"facing_eight_sides", (int)0, (int)7);
    public static final IntegerProperty TONE = IntegerProperty.create((String)"tone", (int)0, (int)9);

    public Gong(BlockBehaviour.Properties properties, boolean threeHigh, VoxelShape shape) {
        super(properties, threeHigh, shape);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_EIGHT_SIDES, (Comparable)Integer.valueOf(0))).setValue((Property)TONE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING_EIGHT_SIDES});
        builder.add(new Property[]{TONE});
    }

    @Override
    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM) {
                int facing = (Integer)level.getBlockState(pos).getValue((Property)FACING_EIGHT_SIDES);
                int tone = (Integer)level.getBlockState(pos).getValue((Property)TONE);
                if (player.isShiftKeyDown()) {
                    if (tone < 7) {
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)TONE, (Comparable)Integer.valueOf(tone + 1)));
                    } else {
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)TONE, (Comparable)Integer.valueOf(0)));
                    }
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    if (facing < 7) {
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)FACING_EIGHT_SIDES, (Comparable)Integer.valueOf(facing + 1)));
                    } else {
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)FACING_EIGHT_SIDES, (Comparable)Integer.valueOf(0)));
                    }
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 1.0f, 0.0f);
                }
            } else if (state.getValue((Property)SEGMENT) == MultiBlockSegment.MIDDLE) {
                int tone = level.getBlockState(pos.below(1)).is(AbyssTechBlocks.GONG) ? (Integer)level.getBlockState(pos.below(1)).getValue((Property)TONE) : 1;
                level.playSound(null, pos, AbyssTechSounds.GONG_PLAY.get(), SoundSource.BLOCKS, 1.0f, (float)tone * 0.2f);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

