/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.InstabilityDetectorBlockEntity;
import org.jetbrains.annotations.Nullable;

public class InstabilityDetectorBlock
extends BaseEntityBlock {
    public static final IntegerProperty instabilityAmount = IntegerProperty.create((String)"instability_amount", (int)0, (int)3);
    public static final IntegerProperty redstonePower = IntegerProperty.create((String)"redstone_power", (int)0, (int)15);
    public static final BooleanProperty noisy = BooleanProperty.create((String)"noisy");
    public static final MapCodec<InstabilityDetectorBlock> CODEC = InstabilityDetectorBlock.simpleCodec(InstabilityDetectorBlock::new);

    public InstabilityDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)instabilityAmount, (Comparable)Integer.valueOf(0))).setValue((Property)noisy, (Comparable)Boolean.valueOf(true))).setValue((Property)redstonePower, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{instabilityAmount});
        builder.add(new Property[]{noisy});
        builder.add(new Property[]{redstonePower});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new InstabilityDetectorBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Integer)state.getValue((Property)redstonePower);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.isShiftKeyDown()) {
            if (((Boolean)level.getBlockState(pos).getValue((Property)noisy)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)noisy, (Comparable)Boolean.valueOf(false)));
            } else {
                level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)noisy, (Comparable)Boolean.valueOf(true)));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return InstabilityDetectorBlock.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.INSTABILITY_DETECTOR_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

