/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.InstabilityStabilizerBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class InstabilityStabilizer
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final IntegerProperty gunkLevel = IntegerProperty.create((String)"gunk_level", (int)0, (int)20);
    public static final BooleanProperty cleanFilter = BooleanProperty.create((String)"clean_filter");
    private static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<InstabilityStabilizer> CODEC = InstabilityStabilizer.simpleCodec(InstabilityStabilizer::new);

    public InstabilityStabilizer(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)gunkLevel, (Comparable)Integer.valueOf(0))).setValue((Property)cleanFilter, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{gunkLevel});
        builder.add(new Property[]{cleanFilter});
        builder.add(new Property[]{FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.getMainHandItem().is((Item)AbyssTechItems.SCRUBBER_FILTER.get()) && !((Boolean)level.getBlockState(pos).getValue((Property)cleanFilter)).booleanValue()) {
            player.getMainHandItem().shrink(1);
            this.replaceFilter(level, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void replaceFilter(Level level, BlockPos pos) {
        if ((Integer)level.getBlockState(pos).getValue((Property)gunkLevel) == 20) {
            AbyssTechUtility.ItemSimpleSpawn(level, pos, AbyssTechItems.ABYSSAL_SLUDGE.asItem());
        }
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)cleanFilter, (Comparable)Boolean.valueOf(true))).setValue((Property)gunkLevel, (Comparable)Integer.valueOf(0)));
        level.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS);
        level.playSound(null, pos, AbyssTechSounds.WRENCH.get(), SoundSource.BLOCKS);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new InstabilityStabilizerBlockEntity(blockPos, blockState);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return InstabilityStabilizer.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.INSTABILITY_STABILIZER_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

