/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.MagGlassBlockEntity;
import net.quasar.abysstech.sound.AbyssTechSounds;
import org.jetbrains.annotations.Nullable;

public class MagGlass
extends BaseEntityBlock {
    public static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)15.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    public static final MapCodec<MagGlass> CODEC = MagGlass.simpleCodec(MagGlass::new);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    public static final IntegerProperty Mag = IntegerProperty.create((String)"mag", (int)0, (int)2);

    public MagGlass(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)Mag, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{Mag});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case UP: {
                return SHAPE_UP;
            }
        }
        return SHAPE_DOWN;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new MagGlassBlockEntity(pPos, pState);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if ((Integer)state.getValue((Property)Mag) < 2) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Mag, (Comparable)Integer.valueOf((Integer)state.getValue((Property)Mag) + 1)));
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Mag, (Comparable)Integer.valueOf(0)));
            }
            level.playSound(null, pos, AbyssTechSounds.STUDY_MAG.get(), SoundSource.BLOCKS);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return MagGlass.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.MAG_GLASS_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

