/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class MimiCap
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty fruiting = BooleanProperty.create((String)"fruiting");
    public static final IntegerProperty stage = IntegerProperty.create((String)"stage", (int)0, (int)3);
    public static final IntegerProperty fruits = IntegerProperty.create((String)"fruits", (int)0, (int)17);
    Random random = new Random();

    public MimiCap(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)fruiting, (Comparable)Boolean.valueOf(false))).setValue((Property)stage, (Comparable)Integer.valueOf(0))).setValue((Property)fruits, (Comparable)Integer.valueOf(17)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{fruiting});
        builder.add(new Property[]{stage});
        builder.add(new Property[]{fruits});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (player.getMainHandItem().is(AbyssTechBlocks.WISP_JAR.asItem())) {
                boolean shrinkAndSound = false;
                if ((Integer)state.getValue((Property)stage) < 3) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)stage, (Comparable)Integer.valueOf((Integer)state.getValue((Property)stage) + 1)));
                    shrinkAndSound = true;
                } else if (!((Boolean)state.getValue((Property)fruiting)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)fruiting, (Comparable)Boolean.valueOf(true)));
                    shrinkAndSound = true;
                }
                if (shrinkAndSound) {
                    player.getMainHandItem().shrink(1);
                    level.playSound(null, pos, SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.BLOCKS);
                    level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS);
                }
            } else if (((Boolean)state.getValue((Property)fruiting)).booleanValue()) {
                if ((Integer)state.getValue((Property)fruits) > 0) {
                    AbyssTechUtility.ItemSimpleSpawn(level, pos, this.getRawOreBelow(level, pos).getItem());
                    level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)fruiting, (Comparable)Boolean.valueOf(false))).setValue((Property)fruits, (Comparable)Integer.valueOf((Integer)state.getValue((Property)fruits) - 1)));
                    level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS);
                } else {
                    AbyssTechUtility.ItemSimpleSpawn(level, pos, this.getRawOreBelow(level, pos).getItem());
                    level.removeBlock(pos, false);
                    this.setSlagBelow(level, pos);
                    level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS);
                    level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_BREAK, SoundSource.BLOCKS);
                }
                if (this.random.nextInt(50) == 1) {
                    AbyssTechUtility.ItemSimpleSpawn(level, pos, AbyssTechItems.MIMIGELL.asItem());
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    private ItemStack getRawOreBelow(Level level, BlockPos pos) {
        if (level.getBlockState(pos.below(1)).is(AbyssTechTags.Blocks.RAW_ORE_BLOCK)) {
            ItemStack oreBlockItem = level.getBlockState(pos.below(1)).getBlock().asItem().getDefaultInstance();
            List recipes = level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
            for (RecipeHolder holder : recipes) {
                ItemStack output = ((CraftingRecipe)holder.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                if (!output.is(oreBlockItem.getItem())) continue;
                for (Ingredient ingredient : ((CraftingRecipe)holder.value()).getIngredients()) {
                    ItemStack[] matchingItems;
                    if (ingredient.isEmpty() || (matchingItems = ingredient.getItems()).length < 1) continue;
                    return new ItemStack((ItemLike)matchingItems[0].getItem(), 1);
                }
            }
        }
        return Blocks.COBBLESTONE.asItem().getDefaultInstance();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide()) {
            if (this.canSurvive(state, (LevelReader)level, pos)) {
                if ((Integer)state.getValue((Property)stage) < 3) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)stage, (Comparable)Integer.valueOf((Integer)state.getValue((Property)stage) + 1)));
                } else if (!((Boolean)state.getValue((Property)fruiting)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)fruiting, (Comparable)Boolean.valueOf(true)));
                }
            } else {
                level.destroyBlock(pos, false);
            }
        }
        super.randomTick(state, level, pos, random);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide() && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide()) {
            this.setSlagBelow(level, pos);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onDestroyedByPushReaction(BlockState state, Level level, BlockPos pos, Direction pushDirection, FluidState fluid) {
        if (!level.isClientSide()) {
            this.setSlagBelow(level, pos);
        }
        super.onDestroyedByPushReaction(state, level, pos, pushDirection, fluid);
    }

    private void setSlagBelow(Level level, BlockPos pos) {
        if (level.getBlockState(pos.below(1)).is(AbyssTechTags.Blocks.RAW_ORE_BLOCK)) {
            level.setBlockAndUpdate(pos.below(1), ((Block)AbyssTechBlocks.SLAG_BLOCK.get()).defaultBlockState());
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below(1));
        return below.is(AbyssTechTags.Blocks.RAW_ORE_BLOCK);
    }
}

