/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.entity.custom.MixableFourBlockStackBlockEntity;
import net.quasar.abysstech.util.AbyssTechTags;
import org.jetbrains.annotations.Nullable;

public class MixableFourBlockStack
extends BaseEntityBlock {
    public static final MapCodec<MixableFourBlockStack> CODEC = MixableFourBlockStack.simpleCodec(MixableFourBlockStack::new);
    public static final VoxelShape SHAPE_ZERO = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape SHAPE_ONE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape SHAPE_TWO = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape SHAPE_THREE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape SHAPE_FOUR = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final IntegerProperty itemsIn = IntegerProperty.create((String)"items_in", (int)0, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public MixableFourBlockStack(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)itemsIn, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{itemsIn});
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MixableFourBlockStackBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Integer)pState.getValue((Property)itemsIn)) {
            case 1 -> SHAPE_ONE;
            case 2 -> SHAPE_TWO;
            case 3 -> SHAPE_THREE;
            case 4 -> SHAPE_FOUR;
            default -> SHAPE_ZERO;
        };
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof MixableFourBlockStackBlockEntity) {
            MixableFourBlockStackBlockEntity mixableBe = (MixableFourBlockStackBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)mixableBe);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MixableFourBlockStackBlockEntity) {
                MixableFourBlockStackBlockEntity mixableBe = (MixableFourBlockStackBlockEntity)blockEntity;
                int itemIn = (Integer)state.getValue((Property)itemsIn);
                if (player.getMainHandItem().is(AbyssTechTags.Items.BIG_BOOK_LIKE) && itemIn < 4) {
                    if (mixableBe.getItem(itemIn).isEmpty()) {
                        mixableBe.setItem(itemIn, player.getMainHandItem());
                        player.getMainHandItem().shrink(1);
                        level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)itemsIn, (Comparable)Integer.valueOf(itemIn + 1)));
                    }
                } else if (!mixableBe.getItem(itemIn - 1).isEmpty() && !player.getMainHandItem().is(AbyssTechTags.Items.BIG_BOOK_LIKE)) {
                    if (itemIn > 2) {
                        ItemStack stackInMixable = mixableBe.getItem(itemIn - 1);
                        mixableBe.removeItem(itemIn - 1, 1);
                        player.setItemInHand(InteractionHand.MAIN_HAND, stackInMixable);
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)itemsIn, (Comparable)Integer.valueOf(itemIn - 1)));
                    } else {
                        ItemStack stackInMixable = mixableBe.getItem(1);
                        BlockState toPlace = (BlockState)Block.byItem((Item)mixableBe.getItem(0).getItem()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
                        mixableBe.clearContent();
                        player.setItemInHand(InteractionHand.MAIN_HAND, stackInMixable);
                        level.setBlockAndUpdate(pos, toPlace);
                    }
                    level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 0.5f);
                }
            }
            level.sendBlockUpdated(pos, state, state, 3);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

