/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.sound.AbyssTechSounds;

public class MortTheStone
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    public static final VoxelShape SHAPE_2 = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    public static final VoxelShape SHAPE_3 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape SHAPE_4 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final VoxelShape SHAPE_FULL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final IntegerProperty foodLevel = IntegerProperty.create((String)"food_level", (int)0, (int)14);
    private final int maxFood = 14;
    Random random = new Random();
    private final String[] messageDialogueDay = new String[]{"Hi :D", "Watch out for creepers!", "Make sure to get plenty of rest!", "Hydrate!", "All is good in the world :D", "Feed me please I'm hungry!", "Mmmm rotten flesh.", "The doorway awaits your arrival...", "Don't look behind you...", "Have a happy day :D", "Make sure to take frequent breaks!", "Can you trust them?", "Some of those blocks your crafting... what's with all the carved faces?", "Those written parchments, they blinked at me once! I'm telling you the truth!", "I always liked the rain.", "Those mort machines you made? I wonder if they have secondary uses...", "Is it really magic? or just another type of technology?", "What is technology but magic we have a solid grasp of...", "I ate some of the pink cotton candy you have in your walls... i feel funny.", "They are hiding in your walls.", "You are really easy to sneak up on :)", "Hope you have a wonderful day :D", "I saw someone with a candle for a head once, I think they owned a haunted library? they seemed pretty chill."};
    private final String[] messageDialogueNight = new String[]{"It's dark out, maybe you should get some rest.", "I hope your well equipped to deal with those monsters...", "Zzzz, Zzzz, Zzzz.", "What was that!?", "A campfire would be perfect right about now.", "Torch spam may be ugly, but It's better then nothing...", "Want to tell scary stories?", "Somethings out there...", "Don't look at the moon.", "I saw someone once who was looking for something hidden under a... red arch? Or something about a flytrap... Sticks is a funny name."};

    public MortTheStone(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)foodLevel, (Comparable)Integer.valueOf(0)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (player.getMainHandItem().is(Items.ROTTEN_FLESH)) {
                if ((Integer)level.getBlockState(pos).getValue((Property)foodLevel) < 14) {
                    player.getMainHandItem().shrink(1);
                    if ((Integer)state.getValue((Property)foodLevel) == 13) {
                        level.playSound(null, pos, AbyssTechSounds.TUBA.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)foodLevel, (Comparable)Integer.valueOf((Integer)level.getBlockState(pos).getValue((Property)foodLevel) + 1)));
                }
            } else {
                String[] messageToSend = level.isDay() ? this.messageDialogueDay : this.messageDialogueNight;
                player.displayClientMessage((Component)Component.literal((String)messageToSend[this.random.nextInt(messageToSend.length)]), false);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{foodLevel});
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Integer)pState.getValue((Property)foodLevel)) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return SHAPE_2;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return SHAPE_3;
            }
            case 13: {
                return SHAPE_4;
            }
            case 14: {
                return SHAPE_FULL;
            }
        }
        return SHAPE;
    }
}

