/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.MortarBlockEntity;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class Mortar
extends BaseEntityBlock {
    public static final MapCodec<Mortar> CODEC = Mortar.simpleCodec(Mortar::new);
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    public static final IntegerProperty ingredientProgress = IntegerProperty.create((String)"ingredient_progress", (int)0, (int)4);
    public static final BooleanProperty progressCooldown = BooleanProperty.create((String)"progress_cooldown");
    public static final BooleanProperty hasItem = BooleanProperty.create((String)"has_item");

    public Mortar(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ingredientProgress, (Comparable)Integer.valueOf(0))).setValue((Property)progressCooldown, (Comparable)Boolean.valueOf(false))).setValue((Property)hasItem, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ingredientProgress});
        builder.add(new Property[]{progressCooldown});
        builder.add(new Property[]{hasItem});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MortarBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof MortarBlockEntity) {
            MortarBlockEntity mortarBlockEntity = (MortarBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)mortarBlockEntity);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MortarBlockEntity) {
                MortarBlockEntity mortarBlockEntity = (MortarBlockEntity)blockEntity;
                if (player.getMainHandItem().is(AbyssTechBlocks.PESTLE.asItem())) {
                    if (!((Boolean)level.getBlockState(pos).getValue((Property)progressCooldown)).booleanValue()) {
                        if (!mortarBlockEntity.isEmpty()) {
                            level.playSound(null, pos, AbyssTechSounds.MORTAR_GRIND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)progressCooldown, (Comparable)Boolean.valueOf(true)));
                    }
                } else {
                    AbyssTechUtility.playerPlaceTakeItem(level, pos, state, mortarBlockEntity, stack, player);
                }
            }
            level.sendBlockUpdated(pos, state, state, 3);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return Mortar.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.MORTAR_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

