/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import org.jetbrains.annotations.Nullable;

public class MultiPlantLike
extends HorizontalBlock {
    public static final IntegerProperty amount = IntegerProperty.create((String)"amount", (int)0, (int)3);
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    public static final VoxelShape SHAPE_TWO = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);
    public static final VoxelShape SHAPE_THREE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    public static final VoxelShape SHAPE_FOUR = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public MultiPlantLike(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)amount, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{amount});
        builder.add(new Property[]{FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.getMainHandItem().is(state.getBlock().asItem()) && (Integer)state.getValue((Property)amount) < 3) {
            player.getMainHandItem().shrink(1);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)amount, (Comparable)Integer.valueOf((Integer)state.getValue((Property)amount) + 1)));
            level.playSound(null, pos, SoundEvents.AZALEA_PLACE, SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void onNeighborChange(BlockState state, LevelReader levelReader, BlockPos pos, BlockPos neighbor) {
        ServerLevel level = ((ServerLevel)levelReader).getLevel();
        if (!level.isClientSide() && !level.getBlockState(pos.below(1)).is(BlockTags.DIRT)) {
            level.destroyBlock(pos, true);
        }
        super.onNeighborChange(state, levelReader, pos, neighbor);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide() && !level.getBlockState(pos.below(1)).is(BlockTags.DIRT)) {
            level.destroyBlock(pos, true);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below(1));
        return below.is(BlockTags.DIRT);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.getValue((Property)amount)) {
            case 1: {
                return SHAPE_TWO;
            }
            case 2: {
                return SHAPE_THREE;
            }
            case 3: {
                return SHAPE_FOUR;
            }
        }
        return SHAPE;
    }
}

