/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.util.AbyssTechUtility;

public class PizzaLike
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    public static final VoxelShape WEST_S1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)8.0);
    public static final VoxelShape WEST_S1A = Block.box((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)2.0, (double)15.0);
    public static final VoxelShape WEST_S2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)8.0);
    public static final VoxelShape WEST_S3 = Block.box((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)8.0);
    public static final VoxelShape EAST_S1 = Block.box((double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)2.0, (double)15.0);
    public static final VoxelShape EAST_S1A = Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)2.0, (double)8.0);
    public static final VoxelShape EAST_S2 = Block.box((double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)2.0, (double)15.0);
    public static final VoxelShape EAST_S3 = Block.box((double)1.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)15.0);
    public static final VoxelShape SOUTH_S1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)2.0, (double)15.0);
    public static final VoxelShape SOUTH_S1A = Block.box((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)8.0);
    public static final VoxelShape SOUTH_S2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)2.0, (double)15.0);
    public static final VoxelShape SOUTH_S3 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)2.0, (double)8.0);
    public static final VoxelShape NORTH_S1 = Block.box((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    public static final VoxelShape NORTH_S1A = Block.box((double)1.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)15.0);
    public static final VoxelShape NORTH_S2 = Block.box((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    public static final VoxelShape NORTH_S3 = Block.box((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)2.0, (double)15.0);
    public static final IntegerProperty SLICE = IntegerProperty.create((String)"slice", (int)0, (int)3);
    public static final BooleanProperty HAS_BOX = BooleanProperty.create((String)"has_box");
    public static final BooleanProperty IS_OPEN = BooleanProperty.create((String)"is_open");
    private final int hungerPoints;
    private final float saturationPoints;
    private final int effectType;

    public PizzaLike(BlockBehaviour.Properties properties, int hungerPoints, float saturationPoints, int effectType) {
        super(properties);
        this.hungerPoints = hungerPoints;
        this.saturationPoints = saturationPoints;
        this.effectType = effectType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SLICE, (Comparable)Integer.valueOf(0))).setValue((Property)HAS_BOX, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLICE});
        builder.add(new Property[]{HAS_BOX});
        builder.add(new Property[]{IS_OPEN});
        builder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Integer)pState.getValue((Property)SLICE)) {
            case 1: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return Shapes.or((VoxelShape)NORTH_S1, (VoxelShape)NORTH_S1A);
                    }
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SOUTH_S1, (VoxelShape)SOUTH_S1A);
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)EAST_S1, (VoxelShape)EAST_S1A);
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)WEST_S1, (VoxelShape)WEST_S1A);
                    }
                }
            }
            case 2: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S2;
                    }
                    case SOUTH: {
                        return SOUTH_S2;
                    }
                    case EAST: {
                        return EAST_S2;
                    }
                    case WEST: {
                        return WEST_S2;
                    }
                }
            }
            case 3: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        return NORTH_S3;
                    }
                    case SOUTH: {
                        return SOUTH_S3;
                    }
                    case EAST: {
                        return EAST_S3;
                    }
                    case WEST: {
                        return WEST_S3;
                    }
                }
            }
        }
        return SHAPE;
    }

    public void eatTheFood(Level level, BlockPos pos, Player player, int slicesTaken) {
        if (slicesTaken < 3) {
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)SLICE, (Comparable)Integer.valueOf(slicesTaken + 1)));
        } else {
            level.removeBlock(pos, false);
        }
        player.getFoodData().eat(this.hungerPoints, this.saturationPoints);
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS);
        switch (this.effectType) {
            case 1: {
                AbyssTechUtility.randomPositiveEffect(player);
                break;
            }
            case 2: {
                AbyssTechUtility.randomNegativeEffect(player);
                break;
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            int slicesTaken = (Integer)level.getBlockState(pos).getValue((Property)SLICE);
            if (((Boolean)state.getValue((Property)HAS_BOX)).booleanValue()) {
                if (player.getMainHandItem().is(Items.SHEARS) && ((Boolean)state.getValue((Property)HAS_BOX)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_BOX, (Comparable)Boolean.valueOf(false)));
                    level.playSound(null, pos, SoundEvents.CHISELED_BOOKSHELF_INSERT, SoundSource.BLOCKS, 1.0f, 0.0f);
                } else if (player.isShiftKeyDown()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)IS_OPEN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)IS_OPEN) == false)));
                    level.playSound(null, pos, SoundEvents.CHISELED_BOOKSHELF_INSERT, SoundSource.BLOCKS);
                } else if (((Boolean)state.getValue((Property)IS_OPEN)).booleanValue()) {
                    this.eatTheFood(level, pos, player, slicesTaken);
                }
            } else if (player.getMainHandItem().is(Items.PAPER) && !((Boolean)state.getValue((Property)HAS_BOX)).booleanValue()) {
                player.getMainHandItem().shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_BOX, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, pos, SoundEvents.CHISELED_BOOKSHELF_INSERT, SoundSource.BLOCKS, 1.0f, 2.0f);
            } else {
                this.eatTheFood(level, pos, player, slicesTaken);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

