/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import org.jetbrains.annotations.Nullable;

public class PlushLike
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final IntegerProperty modelType = IntegerProperty.create((String)"model_type", (int)0, (int)1);
    private final Supplier<Item> specialItem;
    private final int specialEffect;
    private final Supplier<SoundEvent> soundEvent;

    public PlushLike(BlockBehaviour.Properties properties, @Nullable Supplier<Item> specialItem, @Nullable Supplier<SoundEvent> soundEvents, int specialEffect) {
        super(properties);
        this.specialItem = specialItem;
        this.specialEffect = specialEffect;
        this.soundEvent = soundEvents;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)modelType, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{modelType});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if ((Integer)state.getValue((Property)modelType) == 0 && this.specialItem != null) {
                if (player.getMainHandItem().is(this.specialItem.get())) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)modelType, (Comparable)Integer.valueOf(1)));
                    if (this.soundEvent != null) {
                        level.playSound(null, pos, this.soundEvent.get(), SoundSource.BLOCKS);
                    }
                }
            } else if ((Integer)state.getValue((Property)modelType) == 1 && this.specialEffect > 0) {
                this.specialInteraction(level, pos, this.specialEffect);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void specialInteraction(Level level, BlockPos pos, int specialEffect) {
        switch (specialEffect) {
            case 1: {
                level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 8.0f, Level.ExplosionInteraction.TNT);
            }
        }
    }
}

