/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.SigilBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import net.quasar.abysstech.util.special_recipe.AbyssTechRecipes;
import net.quasar.abysstech.util.special_recipe.SigilDreamPoolRecipe;
import org.jetbrains.annotations.Nullable;

public class Sigil
extends BaseEntityBlock {
    public static final MapCodec<Sigil> CODEC = Sigil.simpleCodec(Sigil::new);
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final IntegerProperty sigilType = IntegerProperty.create((String)"sigil_type", (int)0, (int)7);
    public static final BooleanProperty cooldown = BooleanProperty.create((String)"cooldown");
    Random random = new Random();

    public Sigil(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)sigilType, (Comparable)Integer.valueOf(0))).setValue((Property)cooldown, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{sigilType});
        builder.add(new Property[]{cooldown});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SigilBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    /*
     * Unable to fully structure code
     */
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        block7: {
            if (level.isClientSide() || ((Boolean)level.getBlockState(pos).getValue((Property)Sigil.cooldown)).booleanValue()) break block7;
            searchRadius = 6;
            if (!(entity instanceof LivingEntity)) ** GOTO lbl-1000
            livingEntity = (LivingEntity)entity;
            if ((Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType) != 6 || (Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType) != 7) {
                this.effectEntity(level, pos, livingEntity, searchRadius);
            } else if (entity instanceof ItemEntity) {
                itemEntity = (ItemEntity)entity;
                if ((Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType) == 6 || (Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType) == 7) {
                    if ((Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType) == 6) {
                        this.itemTransform(level, pos, itemEntity, searchRadius);
                    } else if ((Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType) == 7) {
                        this.summonMob(level, pos, itemEntity, searchRadius);
                    }
                }
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    private void effectEntity(Level level, BlockPos pos, LivingEntity livingEntity, int searchRadius) {
        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)cooldown, (Comparable)Boolean.valueOf(true)));
        int sigilType = (Integer)level.getBlockState(pos).getValue((Property)Sigil.sigilType);
        int essenceCost = 0;
        switch (sigilType) {
            case 0: {
                essenceCost = 1;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                essenceCost = 3;
                break;
            }
            case 3: {
                essenceCost = 2;
                break;
            }
            case 5: {
                essenceCost = 5;
            }
        }
        boolean foundEssence = AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, essenceCost, 1);
        if (foundEssence) {
            switch (sigilType) {
                case 0: {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 1));
                    break;
                }
                case 1: {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 0));
                    break;
                }
                case 2: {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.HEAL, 1, 0));
                    break;
                }
                case 3: {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 40, 5));
                    break;
                }
                case 4: {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 9));
                    break;
                }
                case 5: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.LIGHTNING_BOLT.create(level));
                }
            }
            level.playSound(null, pos, AbyssTechSounds.SIGIL_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void itemTransform(Level level, BlockPos pos, ItemEntity itemEntity, int searchRadius) {
        List<SigilDreamPoolRecipe> dreamRecipes = AbyssTechRecipes.getAllRecipesOfType(SigilDreamPoolRecipe.class);
        for (SigilDreamPoolRecipe recipe : dreamRecipes) {
            boolean validBlockUnder;
            boolean bl = validBlockUnder = recipe.getBlockUnder() == null || level.getBlockState(pos.below(1)).is(recipe.getBlockUnder());
            if (!itemEntity.getItem().is(recipe.getInput()) || !validBlockUnder || !AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, recipe.getCost(), 2)) continue;
            BlockPos[] normalizerPos = new BlockPos[]{pos.north(1), pos.south(1), pos.east(1), pos.west(1)};
            int normalizers = 0;
            for (int i = 0; i < normalizerPos.length; ++i) {
                if (!level.getBlockState(normalizerPos[i]).is(AbyssTechBlocks.THRESHOLD_NORMALIZER)) continue;
                ++normalizers;
            }
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)cooldown, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, AbyssTechSounds.SIGIL_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            itemEntity.getItem().shrink(1);
            AbyssTechUtility.ItemSimpleSpawn(level, pos, recipe.getOutput(normalizers, this.random));
            if (recipe.getBlockUnder() == null) break;
            level.removeBlock(pos.below(1), false);
            break;
        }
    }

    private void summonMob(Level level, BlockPos pos, ItemEntity itemEntity, int searchRadius) {
        Item[] poolItem = new Item[]{(Item)AbyssTechItems.MUSH_PUFFBALL_FERMENTED.get(), (Item)AbyssTechItems.GUT_PUFFBALL_FERMENTED.get(), (Item)AbyssTechItems.SOL_MOREL_FERMENTED.get(), (Item)AbyssTechItems.CREEPING_MOREL_FERMENTED.get(), (Item)AbyssTechItems.DISTILLATE_MUSH.get(), (Item)AbyssTechItems.TORPOR_CAP_FERMENTED.get(), (Item)AbyssTechItems.DISTILLATE_GUT.get(), (Item)AbyssTechItems.DISTILLATE_TORPOR.get(), (Item)AbyssTechItems.DISTILLATE_CREEPING.get(), (Item)AbyssTechItems.DISTILLATE_SOL.get(), (Item)AbyssTechItems.ROYAL_HONEY_FERMENTED.get(), (Item)AbyssTechItems.DISTILLATE_ROYAL.get()};
        block19: for (int i = 0; i < poolItem.length; ++i) {
            boolean foundEssence;
            int essenceCost = 0;
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 10: 
                case 11: {
                    essenceCost = 5;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    essenceCost = 10;
                    break;
                }
                case 7: {
                    essenceCost = 20;
                }
            }
            if (!itemEntity.getItem().is(poolItem[i]) || !(foundEssence = AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, essenceCost, 3))) continue;
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)cooldown, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, AbyssTechSounds.SIGIL_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            itemEntity.getItem().shrink(1);
            switch (i) {
                case 0: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.PIG.create(level));
                    continue block19;
                }
                case 1: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.COW.create(level));
                    continue block19;
                }
                case 2: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.SHEEP.create(level));
                    continue block19;
                }
                case 3: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.SQUID.create(level));
                    continue block19;
                }
                case 4: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.CREEPER.create(level));
                    continue block19;
                }
                case 5: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.SKELETON.create(level));
                    continue block19;
                }
                case 6: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.ZOMBIE.create(level));
                    continue block19;
                }
                case 7: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.WITHER_SKELETON.create(level));
                    continue block19;
                }
                case 8: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.ENDERMAN.create(level));
                    continue block19;
                }
                case 9: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.PHANTOM.create(level));
                    continue block19;
                }
                case 10: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.BEE.create(level));
                    continue block19;
                }
                case 11: {
                    AbyssTechUtility.MobSimpleSpawn(level, pos, EntityType.WOLF.create(level));
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return Sigil.createTickerHelper(pBlockEntityType, AbyssTechBlockEntities.SIGIL_BLOCK_ENTITY.get(), (level, pPos, pState1, pBLockEntity) -> pBLockEntity.tick(pLevel, pPos, pState1));
    }
}

