/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.LitLike;
import net.quasar.abysstech.block.custom.Sigil;
import net.quasar.abysstech.block.entity.custom.SigilBaseBlockEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class SigilBase
extends BaseEntityBlock {
    public static final MapCodec<SigilBase> CODEC = SigilBase.simpleCodec(SigilBase::new);
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final IntegerProperty sigilModel = IntegerProperty.create((String)"sigil_model", (int)0, (int)8);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public SigilBase(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)sigilModel, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SigilBaseBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{sigilModel});
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Item[] validIngredients = new Item[]{(Item)AbyssTechItems.DECAYING_POWDER.get(), (Item)AbyssTechItems.SPROUTING_POWDER.get(), (Item)AbyssTechItems.STRANGE_POWDER.get(), (Item)AbyssTechItems.CHRYSANTHEMUM_PASTE.get(), (Item)AbyssTechItems.RADIANT_OOZE.get(), (Item)AbyssTechItems.STYGIAN_OOZE.get(), (Item)AbyssTechItems.DIAMOND_POWDER.get(), (Item)AbyssTechItems.DAHLIA_PASTE.get()};
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SigilBaseBlockEntity) {
                SigilBaseBlockEntity sigil = (SigilBaseBlockEntity)blockEntity;
                boolean[] allIng = sigil.getIng();
                if (!player.isShiftKeyDown()) {
                    if (Arrays.asList(validIngredients).contains(player.getMainHandItem().getItem())) {
                        for (int i = 0; i < validIngredients.length; ++i) {
                            if (!player.getMainHandItem().is(validIngredients[i]) || allIng[i]) continue;
                            allIng[i] = true;
                            sigil.setIng(allIng);
                            player.getMainHandItem().shrink(1);
                            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)sigilModel, (Comparable)Integer.valueOf((Integer)state.getValue((Property)sigilModel) + 1)));
                            level.playSound(null, pos, AbyssTechSounds.PARCHMENT_WRITE.get(), SoundSource.BLOCKS);
                            break;
                        }
                    } else if (this.braziersLit(level, pos)) {
                        Item mantra = (Item)AbyssTechItems.UNBOUND_MANTRA.get();
                        int x = 1;
                        int sigilToPlace = 0;
                        for (int i = 0; i < allIng.length; ++i) {
                            if (allIng[i]) {
                                sigilToPlace += x;
                            }
                            x *= 10;
                        }
                        boolean sigilTypeFound = false;
                        int typeToSet = 0;
                        Item toSpawn = null;
                        switch (sigilToPlace) {
                            case 10110: {
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.MARATHON_MANTRA.get();
                                break;
                            }
                            case 1010001: {
                                typeToSet = 1;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.ANGRY_MANTRA.get();
                                break;
                            }
                            case 1010010: {
                                typeToSet = 2;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.PASSIONATE_MANTRA.get();
                                break;
                            }
                            case 1011100: {
                                typeToSet = 3;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.SOFT_MANTRA.get();
                                break;
                            }
                            case 101101: {
                                typeToSet = 4;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.STONE_MANTRA.get();
                                break;
                            }
                            case 1011000: {
                                typeToSet = 5;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.CAPTIVATING_MANTRA.get();
                                break;
                            }
                            case 111100: {
                                typeToSet = 6;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.WHIMSICAL_MANTRA.get();
                                break;
                            }
                            case 10010: {
                                typeToSet = 7;
                                sigilTypeFound = true;
                                toSpawn = (Item)AbyssTechItems.STRANGE_MANTRA.get();
                            }
                        }
                        if (sigilTypeFound) {
                            if (player.getMainHandItem().is(mantra.asItem())) {
                                level.removeBlock(pos, false);
                                player.getMainHandItem().shrink(1);
                                AbyssTechUtility.ItemSimpleSpawn(level, pos, toSpawn);
                            } else {
                                level.setBlockAndUpdate(pos, (BlockState)((Block)AbyssTechBlocks.SIGIL.get()).defaultBlockState().setValue((Property)Sigil.sigilType, (Comparable)Integer.valueOf(typeToSet)));
                                level.playSound(null, pos, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.0f);
                                level.playSound(null, pos, AbyssTechSounds.SIGIL_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < allIng.length; ++i) {
                        if (allIng[i]) {
                            AbyssTechUtility.ItemSimpleSpawn(level, pos, validIngredients[i]);
                        }
                        allIng[i] = false;
                    }
                    sigil.setIng(allIng);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)sigilModel, (Comparable)Integer.valueOf(0)));
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    private boolean braziersLit(Level level, BlockPos pos) {
        return level.getBlockState(pos.east(1)).is((Block)AbyssTechBlocks.BRAZIER.get()) && level.getBlockState(pos.west(1)).is((Block)AbyssTechBlocks.BRAZIER.get()) ? (Boolean)level.getBlockState(pos.east(1)).getValue((Property)LitLike.Lit) != false && (Boolean)level.getBlockState(pos.west(1)).getValue((Property)LitLike.Lit) != false && (level.getBlockState(pos).getValue((Property)FACING) == Direction.NORTH || level.getBlockState(pos).getValue((Property)FACING) == Direction.SOUTH) : level.getBlockState(pos.north(1)).is((Block)AbyssTechBlocks.BRAZIER.get()) && level.getBlockState(pos.south(1)).is((Block)AbyssTechBlocks.BRAZIER.get()) && (Boolean)level.getBlockState(pos.north(1)).getValue((Property)LitLike.Lit) != false && (Boolean)level.getBlockState(pos.south(1)).getValue((Property)LitLike.Lit) != false && (level.getBlockState(pos).getValue((Property)FACING) == Direction.EAST || level.getBlockState(pos).getValue((Property)FACING) == Direction.WEST);
    }
}

