/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.SimpleShapedBlock;
import org.jetbrains.annotations.Nullable;

public class SingleBoolCustomShapeBlock
extends SimpleShapedBlock {
    public static final BooleanProperty boolState = BooleanProperty.create((String)"bool_state");
    private final boolean useToggle;
    private final SoundEvent sound;

    public SingleBoolCustomShapeBlock(BlockBehaviour.Properties properties, boolean useToggle, @Nullable SoundEvent sound, @Nullable VoxelShape shape) {
        super(properties, shape);
        this.useToggle = useToggle;
        this.sound = sound;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)boolState, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{boolState});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!this.useToggle) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)boolState, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)boolState) == false)));
            if (this.sound != null) {
                level.playSound(null, pos, this.sound, SoundSource.BLOCKS);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

