/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.custom.TallBlock;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class SkyTuba
extends TallBlock {
    public static final IntegerProperty codeInput = IntegerProperty.create((String)"code_input", (int)0, (int)4);
    private static int signalSum = 0;
    Random random = new Random();

    public SkyTuba(BlockBehaviour.Properties properties, boolean threeHigh, VoxelShape shape) {
        super(properties, threeHigh, shape);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)codeInput, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{codeInput});
    }

    @Override
    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM) {
                int highPowerLevel = 0;
                int searchRadius = 6;
                for (Direction direction : Direction.values()) {
                    highPowerLevel = Math.max(highPowerLevel, level.getSignal(pos, direction));
                }
                if (highPowerLevel > 0) {
                    float pitch = Math.min(Math.max((float)highPowerLevel * 0.125f, 0.0f), 2.0f);
                    level.playSound(null, pos, AbyssTechSounds.TUBA_BIG.get(), SoundSource.BLOCKS, 1.0f, pitch);
                    float i = 0.0f;
                    while ((double)i < 0.8) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.SOUND_WAVE_PARTICLES.get(), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.5f + i), (double)((float)pos.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                        i += 0.2f;
                    }
                    if ((Integer)level.getBlockState(pos).getValue((Property)codeInput) < 4) {
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)codeInput, (Comparable)Integer.valueOf((Integer)level.getBlockState(pos).getValue((Property)codeInput) + 1)));
                        signalSum += highPowerLevel;
                    } else {
                        level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)codeInput, (Comparable)Integer.valueOf(0)));
                        boolean foundEssence = AbyssTechUtility.SearchAndTakeEssence(level, pos, searchRadius, switch (signalSum) {
                            case 12 -> 50;
                            case 27 -> 100;
                            default -> 80;
                        }, 5);
                        if (foundEssence) {
                            LevelData levelData = level.getLevelData();
                            switch (signalSum) {
                                case 12: {
                                    for (int i2 = 0; i2 < Math.max(this.random.nextInt(24), 12); ++i2) {
                                        AbyssTechUtility.MobSimpleSpawn(level, pos.offset(this.random.nextInt(24) - 12, 64, this.random.nextInt(24) - 12), EntityType.SLIME.create(level));
                                    }
                                    break;
                                }
                                case 27: {
                                    serverLevel.setDayTime(level.getDayTime() + 12000L);
                                    break;
                                }
                                default: {
                                    levelData.setRaining(!levelData.isRaining());
                                }
                            }
                            level.playSound(null, pos, AbyssTechSounds.MANTRA_USE.get(), SoundSource.BLOCKS, 1.0f, this.random.nextFloat(2.0f));
                        }
                        signalSum = 0;
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM;
    }
}

