/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.util.AbyssTechUtility;

public class SodLike
extends Block {
    private static final BooleanProperty LETHARGIC = BooleanProperty.create((String)"lethargic");
    private final int type;

    public SodLike(BlockBehaviour.Properties properties, int type) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LETHARGIC, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LETHARGIC});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && player.getItemInHand(hand).is(AbyssTechItems.TORPOR_SPORES) && !((Boolean)state.getValue((Property)LETHARGIC)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LETHARGIC, (Comparable)Boolean.valueOf(true)));
            player.getItemInHand(hand).shrink(1);
            level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.isClientSide() && !((Boolean)state.getValue((Property)LETHARGIC)).booleanValue()) {
            switch (this.type) {
                case 0: {
                    if (!(entity instanceof Monster)) break;
                    Monster monster = (Monster)entity;
                    AbyssTechUtility.MobSimpleSpawn(level, pos, monster.getType().create(level));
                    level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                    break;
                }
                case 1: {
                    if (!(entity instanceof LivingEntity)) break;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    Entity toSpawn = livingEntity.getType().create(level);
                    if (toSpawn instanceof PathfinderMob) {
                        PathfinderMob toSpawnPathfinder = (PathfinderMob)toSpawn;
                        AbyssTechUtility.MobSpawnAggressiveTowards(level, pos, toSpawnPathfinder, (LivingEntity)entity);
                    } else {
                        AbyssTechUtility.MobSimpleSpawn(level, pos, toSpawn);
                    }
                    level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                    break;
                }
                case 2: {
                    if (!(entity instanceof Animal)) break;
                    Animal animal = (Animal)entity;
                    AbyssTechUtility.MobSimpleSpawn(level, pos, animal.getType().create(level));
                    level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                }
            }
        }
    }
}

