/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.util.growth.GrowthSet;

public class SpreadingBase
extends Block {
    private final GrowthSet growthSet;
    private final int foliageChance;
    private final int rareFoliageChance;
    private final int altBlockChance;
    private final int spreadDensity;
    private boolean canSpread;
    Random random = new Random();

    public SpreadingBase(BlockBehaviour.Properties properties, GrowthSet growthSet, int foliageChance, int rareFoliageChance, int altBlockChance, int spreadDensity, boolean canSpread) {
        super(properties);
        this.growthSet = growthSet;
        this.foliageChance = foliageChance;
        this.altBlockChance = altBlockChance;
        this.canSpread = canSpread;
        this.rareFoliageChance = rareFoliageChance;
        this.spreadDensity = spreadDensity;
    }

    protected void canSpread(boolean canSpread) {
        this.canSpread = canSpread;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.canSpread && !level.isClientSide() && level.isAreaLoaded(pos, 3)) {
            for (int i = 0; i < this.spreadDensity; ++i) {
                BlockPos targetBlockPos = pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1);
                if (!this.growthSet.isReplaceableAtPos((Level)level, targetBlockPos)) continue;
                Block toPlace = this.growthSet.getRandomAltSpreadingBlock(this.altBlockChance);
                if (toPlace != null) {
                    level.setBlockAndUpdate(targetBlockPos, toPlace.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(targetBlockPos, state);
                }
                this.placeFoliageAt((Level)level, targetBlockPos, this.growthSet.getRandomFoliage(), this.foliageChance);
                this.placeFoliageAt((Level)level, targetBlockPos, this.growthSet.getRandomRareFoliage(), this.rareFoliageChance);
            }
        }
        super.randomTick(state, level, pos, random);
    }

    private void placeFoliageAt(Level level, BlockPos targetPos, Block block, int chance) {
        if (this.random.nextInt(chance) == 1 && block != null && level.getBlockState(targetPos.above(1)).isAir()) {
            if (block instanceof DoublePlantBlock) {
                if (level.getBlockState(targetPos.above(2)).isAir()) {
                    level.setBlock(targetPos.above(1), (BlockState)block.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
                    level.setBlock(targetPos.above(2), (BlockState)block.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
                }
            } else {
                level.setBlockAndUpdate(targetPos.above(1), block.defaultBlockState());
            }
        }
    }
}

