/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.custom.HorizontalBlock;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import org.jetbrains.annotations.Nullable;

public class TallBlock
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<MultiBlockSegment> SEGMENT = EnumProperty.create((String)"segment", MultiBlockSegment.class);
    private final boolean threeHigh;
    private final VoxelShape voxelShape;

    public TallBlock(BlockBehaviour.Properties properties, boolean threeHigh, @Nullable VoxelShape shape) {
        super(properties);
        this.threeHigh = threeHigh;
        this.voxelShape = shape;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SEGMENT, (Comparable)((Object)MultiBlockSegment.BOTTOM)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SEGMENT});
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock() && !level.isClientSide()) {
            BlockPos[] segmentPos;
            BlockPos[] blockPosArray;
            switch ((MultiBlockSegment)((Object)state.getValue(SEGMENT))) {
                case BOTTOM: {
                    if (this.threeHigh) {
                        BlockPos[] blockPosArray2 = new BlockPos[2];
                        blockPosArray2[0] = pos.above(1);
                        blockPosArray = blockPosArray2;
                        blockPosArray2[1] = pos.above(2);
                        break;
                    }
                    BlockPos[] blockPosArray3 = new BlockPos[1];
                    blockPosArray = blockPosArray3;
                    blockPosArray3[0] = pos.above(1);
                    break;
                }
                case MIDDLE: {
                    if (this.threeHigh) {
                        BlockPos[] blockPosArray4 = new BlockPos[2];
                        blockPosArray4[0] = pos.below(1);
                        blockPosArray = blockPosArray4;
                        blockPosArray4[1] = pos.above(1);
                        break;
                    }
                    BlockPos[] blockPosArray5 = new BlockPos[1];
                    blockPosArray = blockPosArray5;
                    blockPosArray5[0] = pos.below(1);
                    break;
                }
                default: {
                    BlockPos[] blockPosArray6 = new BlockPos[2];
                    blockPosArray6[0] = pos.below(1);
                    blockPosArray = blockPosArray6;
                    blockPosArray6[1] = pos.below(2);
                }
            }
            for (BlockPos segmentP : segmentPos = blockPosArray) {
                if (!level.getBlockState(segmentP).is(state.getBlock())) continue;
                level.removeBlock(segmentP, false);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide() && state.getValue(SEGMENT) == MultiBlockSegment.BOTTOM) {
            level.setBlockAndUpdate(pos.above(1), (BlockState)((BlockState)state.setValue(SEGMENT, (Comparable)((Object)MultiBlockSegment.MIDDLE))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            if (this.threeHigh) {
                level.setBlockAndUpdate(pos.above(2), (BlockState)((BlockState)state.setValue(SEGMENT, (Comparable)((Object)MultiBlockSegment.TOP))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            }
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.threeHigh) {
            return level.getBlockState(pos.above(1)).isAir() && level.getBlockState(pos.above(2)).isAir();
        }
        return level.getBlockState(pos.above(1)).isAir();
    }

    public boolean validPlace(BlockState state, LevelReader levelReader, BlockPos pos) {
        return this.canSurvive(state, levelReader, pos);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.voxelShape == null ? SHAPE : this.voxelShape;
    }
}

