/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TallCropLike
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);
    private final Supplier<Item> seed;

    public TallCropLike(BlockBehaviour.Properties properties, Supplier<Item> seed) {
        super(properties);
        this.seed = seed;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        builder.add(new Property[]{HALF});
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide() && (Integer)state.getValue((Property)AGE) < 3 && random.nextInt(4) == 1) {
            this.place((Level)level, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), pos);
        }
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)this.seed.get();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos).getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)AGE) < 3) {
            this.place((Level)serverLevel, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)AGE) + 1)), blockPos);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.survive(level, pos);
    }

    private boolean isLowerHalf(LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below(1)).getBlock() instanceof TallCropLike && level.getBlockState(pos.below(1)).getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public void place(Level level, BlockState state, BlockPos pos) {
        TallCropLike.placeAt((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)3);
    }

    public boolean survive(LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below(1)).is(BlockTags.DIRT) || level.getBlockState(pos.below(1)).is(Blocks.FARMLAND) || this.isLowerHalf(level, pos);
    }
}

