/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.HorizontalBlock;

public class TapestryLike
extends HorizontalBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final int MODELS_MAX = 9;
    public static final IntegerProperty modelType = IntegerProperty.create((String)"model_type", (int)0, (int)9);

    public TapestryLike(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)modelType, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{modelType});
    }

    public String getLore(BlockState state) {
        return Component.translatable((String)("notes_text.abysstech.notes_" + String.valueOf(state.getValue((Property)modelType)))).getString();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockState blockInstance;
        if (!level.isClientSide() && (blockInstance = level.getBlockState(pos).getBlock().defaultBlockState()).is((Block)AbyssTechBlocks.NOTES_BLOCK.get())) {
            int currentModelType = (Integer)level.getBlockState(pos).getValue((Property)modelType);
            currentModelType = currentModelType < 9 ? currentModelType + 1 : 0;
            level.setBlockAndUpdate(pos, (BlockState)level.getBlockState(pos).setValue((Property)modelType, (Comparable)Integer.valueOf(currentModelType)));
            level.playSound(null, pos, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS);
        }
        return InteractionResult.SUCCESS;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE;
    }
}

