/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.custom.TallBlock;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class ThresholdObelisk
extends TallBlock {
    public static final IntegerProperty CHARGE = IntegerProperty.create((String)"charge", (int)0, (int)10);
    public static final IntegerProperty SWAY = IntegerProperty.create((String)"sway", (int)0, (int)2);

    public ThresholdObelisk(BlockBehaviour.Properties properties, boolean threeHigh, @Nullable VoxelShape shape) {
        super(properties, threeHigh, shape);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CHARGE, (Comparable)Integer.valueOf(0))).setValue((Property)SWAY, (Comparable)Integer.valueOf(1)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide() && state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM && player.getItemInHand(hand).is(AbyssTechBlocks.BOUNDARY_GEM_BLOCK.asItem()) && (Integer)state.getValue((Property)CHARGE) == 0) {
            this.replaceObelisk(level, pos, state, 10);
            player.getItemInHand(hand).shrink(1);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide() && state.getValue((Property)SEGMENT) == MultiBlockSegment.BOTTOM && (Integer)state.getValue((Property)CHARGE) > 0) {
            if ((Integer)state.getValue((Property)SWAY) == 0) {
                if (AbyssTechUtility.getThresholdIntegrity((Level)level, pos) >= 200) {
                    AbyssTechUtility.setThresholdIntegrity((Level)level, pos, 200, false);
                    this.replaceObelisk((Level)level, pos, state, (Integer)state.getValue((Property)CHARGE) - 1);
                }
            } else if ((Integer)state.getValue((Property)SWAY) == 2) {
                AbyssTechUtility.setThresholdIntegrity((Level)level, pos, 200, true);
                this.replaceObelisk((Level)level, pos, state, (Integer)state.getValue((Property)CHARGE) - 1);
            }
        }
    }

    private void replaceObelisk(Level level, BlockPos pos, BlockState state, int newCharge) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CHARGE, (Comparable)Integer.valueOf(newCharge)));
        level.setBlockAndUpdate(pos.above(1), (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)SEGMENT, (Comparable)((Object)MultiBlockSegment.MIDDLE)));
        level.setBlockAndUpdate(pos.above(2), (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)SEGMENT, (Comparable)((Object)MultiBlockSegment.TOP)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CHARGE});
        builder.add(new Property[]{SWAY});
    }
}

